/*
 * Decompiled with CFR 0.152.
 */
package serverutils.aurora.mc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ChatComponentTranslation;
import serverutils.ServerUtilitiesCommon;
import serverutils.aurora.AuroraConfig;
import serverutils.aurora.PageType;
import serverutils.aurora.page.HTTPWebPage;
import serverutils.aurora.tag.Style;
import serverutils.aurora.tag.Tag;
import serverutils.data.NodeEntry;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigDouble;
import serverutils.lib.config.ConfigInt;
import serverutils.lib.config.ConfigTimer;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.DefaultPermissionHandler;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;

public class PermissionListPage
extends HTTPWebPage {
    @Override
    public String getTitle() {
        return "Server Utilities";
    }

    @Override
    public String getDescription() {
        return "Permission List";
    }

    @Override
    public String getIcon() {
        return "https:i.imgur.com/m8KTq4s.png";
    }

    @Override
    public PageType getPageType() {
        return AuroraConfig.pages.permission_list_page;
    }

    @Override
    public void head(Tag head) {
        super.head(head);
        Style s = head.style();
        s.add("p").set("margin", "0");
        s.add("code.variants:hover").set("cursor", "default").set("text-decoration", "underline dotted");
    }

    private String classOf(ConfigValue value) {
        if (value instanceof ConfigBoolean) {
            return value.getBoolean() ? "yes" : "no";
        }
        return "other";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void body(Tag body) {
        body.h1("Permission List");
        ArrayList<NodeEntry> allNodes = new ArrayList<NodeEntry>(ServerUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY);
        for (String s : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
            DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(s);
            String desc = PermissionAPI.getPermissionHandler().getNodeDescription(s);
            boolean printNode = true;
            for (NodeEntry cprefix : ServerUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                if (!s.startsWith(cprefix.getNode())) continue;
                if (cprefix.level == null || level != cprefix.level || !desc.isEmpty()) break;
                printNode = false;
                break;
            }
            if (!printNode) continue;
            allNodes.add(new NodeEntry(s, level, desc));
        }
        for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
            String desc = new ChatComponentTranslation("permission." + info.node, new Object[0]).func_150260_c();
            allNodes.add(new NodeEntry(info.node, info.defaultValue, info.defaultOPValue, desc.equals(info.node) ? "" : desc, null));
        }
        allNodes.sort(null);
        Tag nodeTable = body.table();
        Tag firstRow = nodeTable.tr();
        firstRow.th().text("Node");
        firstRow.th().text("Type");
        firstRow.th().text("Player");
        firstRow.th().text("OP");
        ArrayList<List<String>> export = new ArrayList<List<String>>();
        export.add(Arrays.asList("Node", "Type", "Player default", "OP default", "Variants"));
        export.add(Arrays.asList("", "", "", "", ""));
        for (NodeEntry entry : allNodes) {
            void var10_14;
            Tag row = nodeTable.tr();
            Tag n = row.td();
            n.paired("code", entry.getNode());
            if (!entry.desc.isEmpty()) {
                n.text(" ");
                n.icon("info").title(Arrays.asList(entry.desc.split("\n")));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (entry.player instanceof ConfigBoolean) {
                arrayList.add("Variants:");
                arrayList.add("true");
                arrayList.add("false");
            } else {
                ConfigValue configValue = entry.player;
                if (configValue instanceof ConfigInt) {
                    ConfigInt configInt = (ConfigInt)configValue;
                    int min = configInt.getMin();
                    int max = configInt.getMax();
                    arrayList.add(String.format("%s to %s", min == Integer.MIN_VALUE ? "-&infin;" : String.valueOf(min), max == Integer.MAX_VALUE ? "&infin;" : String.valueOf(max)));
                } else {
                    ConfigValue min = entry.player;
                    if (min instanceof ConfigDouble) {
                        ConfigDouble configDouble = (ConfigDouble)min;
                        double min2 = configDouble.getMin();
                        double max = configDouble.getMax();
                        arrayList.add(String.format("%s to %s", min2 == Double.NEGATIVE_INFINITY ? "-&infin;" : StringUtils.formatDouble(min2), max == Double.POSITIVE_INFINITY ? "&infin;" : StringUtils.formatDouble(max)));
                    } else {
                        ConfigValue min2 = entry.player;
                        if (min2 instanceof ConfigTimer) {
                            ConfigTimer configTimer = (ConfigTimer)min2;
                            Ticks max = configTimer.getMax();
                            arrayList.add(String.format("0s to %s", !max.hasTicks() ? "&infin;" : max.toString()));
                        } else {
                            ArrayList<String> arrayList2 = new ArrayList<String>(entry.player.getVariants());
                            arrayList2.sort(StringUtils.IGNORE_CASE_COMPARATOR);
                            arrayList2.add(0, "Variants:");
                        }
                    }
                }
            }
            if (var10_14.isEmpty()) {
                row.td().paired("code", entry.player.getId());
            } else {
                row.td().paired("code", entry.player.getId()).addClass("variants").title((Iterable<String>)var10_14);
            }
            String playerText = Tag.fixHTML(entry.player.getStringForGUI().func_150260_c());
            String opText = Tag.fixHTML(entry.op.getStringForGUI().func_150260_c());
            if (playerText.equals(opText)) {
                row.td().addClass("center-text").attr("colspan", "2").span("", this.classOf(entry.player)).paired("code", playerText);
            } else {
                row.td().addClass("center-text").span("", this.classOf(entry.player)).paired("code", playerText);
                row.td().addClass("center-text").span("", this.classOf(entry.op)).paired("code", opText);
            }
            ArrayList variants2 = new ArrayList(var10_14);
            if (((String)variants2.get(0)).equals("Variants:")) {
                variants2.remove(0);
            }
            export.add(Arrays.asList(entry.getNode(), entry.player.getId(), entry.player.getStringForGUI().func_150260_c(), entry.op.getStringForGUI().func_150260_c(), ((Object)variants2).toString()));
        }
        try {
            ArrayList<String> export2 = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            int[] maxLength = new int[5];
            for (List list : export) {
                for (int i = 0; i < maxLength.length; ++i) {
                    maxLength[i] = Math.max(maxLength[i], ((String)list.get(i)).length());
                }
            }
            for (List list : export) {
                builder.setLength(0);
                for (int i = 0; i < maxLength.length; ++i) {
                    if (i > 0) {
                        builder.append(" | ");
                    }
                    builder.append(StringUtils.fillString((CharSequence)list.get(i), ' ', maxLength[i]));
                }
                export2.add(builder.toString());
            }
            Files.write(Paths.get("server-utilities-permissions.txt", new String[0]), export2, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

