/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import serverutils.lib.tile.EnumSaveType;
import serverutils.lib.tile.IChangeCallback;
import serverutils.lib.util.BlockUtils;

public abstract class TileBase
extends TileEntity
implements IChangeCallback {
    public boolean brokenByCreative = false;
    private boolean isDirty = true;

    protected abstract void writeData(NBTTagCompound var1, EnumSaveType var2);

    protected abstract void readData(NBTTagCompound var1, EnumSaveType var2);

    public boolean hasCustomName() {
        return false;
    }

    public IChatComponent getDisplayName() {
        return new ChatComponentTranslation(this.func_145838_q().func_149739_a() + ".name", new Object[0]);
    }

    public final void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeData(nbt, EnumSaveType.SAVE);
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt, EnumSaveType.SAVE);
    }

    public final S35PacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        super.func_145841_b(nbt);
        this.writeData(nbt, EnumSaveType.NET_UPDATE);
        nbt.func_82580_o("id");
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        return nbt.func_82582_d() ? null : new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readData(pkt.func_148857_g(), EnumSaveType.NET_UPDATE);
        this.onUpdatePacket(EnumSaveType.NET_UPDATE);
    }

    public final NBTTagCompound getUpdateTag() {
        NBTTagCompound nbt = new NBTTagCompound();
        super.func_145841_b(nbt);
        this.writeData(nbt, EnumSaveType.NET_FULL);
        nbt.func_82580_o("id");
        return nbt;
    }

    public final void handleUpdateTag(NBTTagCompound tag) {
        this.readData(tag, EnumSaveType.NET_FULL);
        this.onUpdatePacket(EnumSaveType.NET_FULL);
    }

    public void onUpdatePacket(EnumSaveType type) {
        this.func_70296_d();
    }

    protected boolean notifyBlock() {
        return true;
    }

    public boolean updateComparator() {
        return false;
    }

    public void onLoad() {
        this.isDirty = true;
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    @Override
    public void onContentsChanged(boolean majorChange) {
        this.func_70296_d();
    }

    public void readFromItem(ItemStack stack) {
        NBTTagCompound nbt = BlockUtils.getData(stack);
        if (!nbt.func_82582_d()) {
            this.readData(nbt, EnumSaveType.ITEM);
        }
    }
}

