/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task.backup;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.compression.ICompress;
import serverutils.task.backup.BackupTask;

public class ThreadBackup
extends Thread {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static long logMillis;
    private final File src0;
    private final String customName;
    private final Set<ChunkDimPos> chunksToBackup;
    public boolean isDone = false;
    private final ICompress compressor;

    public ThreadBackup(ICompress compress, File sourceFile, String backupName, Set<ChunkDimPos> backupChunks) {
        this.src0 = sourceFile;
        this.customName = backupName;
        this.chunksToBackup = backupChunks;
        this.compressor = compress;
        this.setPriority(7);
    }

    @Override
    public void run() {
        this.isDone = false;
        ThreadBackup.doBackup(this.compressor, this.src0, this.customName, this.chunksToBackup);
        this.isDone = true;
    }

    private static void addBaseFolderFiles(List<File> files, File saveFile) {
        String saveName = saveFile.getName();
        for (String pattern : ServerUtilitiesConfig.backups.additional_backup_files) {
            int firstWildcardIndex = (pattern = pattern.replace("$WORLDNAME", saveName)).indexOf(42);
            if (firstWildcardIndex == -1) {
                files.addAll(FileUtils.listTree(new File(pattern)));
                continue;
            }
            Path rootFolder = Paths.get(pattern.substring(0, firstWildcardIndex), new String[0]);
            if (firstWildcardIndex != 0 && pattern.charAt(firstWildcardIndex - 1) != '/') {
                rootFolder = rootFolder.getParent();
            }
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
            List<File> fileCandidates = FileUtils.listTree(rootFolder.toFile());
            for (File file : fileCandidates) {
                if (!matcher.matches(file.toPath())) continue;
                files.add(file);
            }
        }
    }

    public static void doBackup(ICompress compressor, File src, String customName, Set<ChunkDimPos> chunks) {
        block12: {
            String outName = (customName.isEmpty() ? DATE_FORMAT.format(Calendar.getInstance().getTime()) : customName) + ".zip";
            File dstFile = null;
            try {
                List<File> files = FileUtils.listTree(src);
                ThreadBackup.addBaseFolderFiles(files, src);
                long start = System.currentTimeMillis();
                logMillis = start + Ticks.SECOND.x(5L).millis();
                dstFile = FileUtils.newFile(new File(BackupTask.BACKUP_FOLDER, outName));
                try (ICompress iCompress = compressor;){
                    compressor.createOutputStream(dstFile);
                    if (!chunks.isEmpty() && ServerUtilitiesConfig.backups.only_backup_claimed_chunks) {
                        ThreadBackup.backupRegions(files, chunks, compressor);
                    } else {
                        ThreadBackup.compressFiles(files, compressor);
                    }
                    String backupSize = FileUtils.getSizeString(dstFile);
                    ServerUtilities.LOGGER.info("Backup done in {} seconds ({})!", new Object[]{ThreadBackup.getDoneTime(start), backupSize});
                    ServerUtilities.LOGGER.info("Created {} from {}", new Object[]{dstFile.getAbsolutePath(), src.getAbsolutePath()});
                    if (ServerUtilitiesConfig.backups.display_file_size) {
                        String sizeT = FileUtils.getSizeString(BackupTask.BACKUP_FOLDER);
                        ServerUtilitiesNotifications.BACKUP.sendAll(StringUtils.color("cmd.backup_end_2", EnumChatFormatting.LIGHT_PURPLE, ThreadBackup.getDoneTime(start), backupSize.equals(sizeT) ? backupSize : backupSize + " | " + sizeT));
                    } else {
                        ServerUtilitiesNotifications.BACKUP.sendAll(StringUtils.color("cmd.backup_end_1", EnumChatFormatting.LIGHT_PURPLE, ThreadBackup.getDoneTime(start)));
                    }
                }
            }
            catch (Exception e) {
                ServerUtils.notifyChat(ServerUtils.getServer(), null, StringUtils.color("cmd.backup_fail", EnumChatFormatting.RED, e.getMessage()));
                ServerUtilities.LOGGER.error("Error while backing up", (Throwable)e);
                if (dstFile == null) break block12;
                FileUtils.delete(dstFile);
            }
        }
    }

    private static void logProgress(int i, int allFiles, String name) {
        boolean first;
        long millis = System.currentTimeMillis();
        boolean bl = first = i == 0;
        if (first) {
            ServerUtilities.LOGGER.info("Backing up {} files...", new Object[]{allFiles});
        }
        if (first || millis > logMillis || i == allFiles - 1) {
            logMillis = millis + Ticks.SECOND.x(5L).millis();
            ServerUtilities.LOGGER.info("[{} | {}%]: {}", new Object[]{i, StringUtils.formatDouble00((double)i / (double)allFiles * 100.0), name});
        }
    }

    private static void compressFiles(List<File> files, ICompress compressor) throws IOException {
        int allFiles = files.size();
        for (int i = 0; i < allFiles; ++i) {
            File file = files.get(i);
            ThreadBackup.compressFile(FileUtils.getRelativePath(file), file, compressor, i, allFiles);
        }
    }

    private static void compressFile(String entryName, File file, ICompress compressor, int index, int totalFiles) throws IOException {
        ThreadBackup.logProgress(index, totalFiles, file.getAbsolutePath());
        compressor.addFileToArchive(file, entryName);
    }

    private static void backupRegions(List<File> files, Set<ChunkDimPos> chunksToBackup, ICompress compressor) throws IOException {
        Object2ObjectMap<File, ObjectSet<ChunkDimPos>> dimRegionClaims = ThreadBackup.mapClaimsToRegionFile(chunksToBackup);
        files.removeIf(f -> f.getName().endsWith(".mca"));
        int index = 0;
        int savedChunks = 0;
        int regionFiles = dimRegionClaims.size();
        int totalFiles = files.size() + regionFiles;
        if (ServerUtilitiesConfig.backups.backup_entire_regions_with_claims) {
            for (Object2ObjectMap.Entry entry : dimRegionClaims.object2ObjectEntrySet()) {
                File regionFile = (File)entry.getKey();
                ObjectSet claimedChunks = (ObjectSet)entry.getValue();
                savedChunks += claimedChunks.size();
                ThreadBackup.compressFile(FileUtils.getRelativePath(regionFile), regionFile, compressor, index++, totalFiles);
            }
            ServerUtilities.LOGGER.info("Backed up {} entire regions containing {} claimed chunks", new Object[]{regionFiles, savedChunks});
        } else {
            for (Object2ObjectMap.Entry entry : dimRegionClaims.object2ObjectEntrySet()) {
                File file = (File)entry.getKey();
                File dimensionRoot = file.getParentFile().getParentFile();
                File tempFile = FileUtils.newFile(new File(BackupTask.BACKUP_TEMP_FOLDER, file.getName()));
                RegionFile tempRegion = new RegionFile(tempFile);
                boolean hasData = false;
                for (ChunkDimPos pos : (ObjectSet)entry.getValue()) {
                    DataInputStream in = RegionFileCache.func_76549_c((File)dimensionRoot, (int)pos.posX, (int)pos.posZ);
                    if (in == null) continue;
                    ++savedChunks;
                    hasData = true;
                    NBTTagCompound tag = CompressedStreamTools.func_74794_a((DataInputStream)in);
                    DataOutputStream tempOut = tempRegion.func_76710_b(pos.posX & 0x1F, pos.posZ & 0x1F);
                    CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)tempOut);
                    tempOut.close();
                }
                tempRegion.func_76708_c();
                if (hasData) {
                    ThreadBackup.compressFile(FileUtils.getRelativePath(file), tempFile, compressor, index++, totalFiles);
                }
                FileUtils.delete(tempFile);
            }
            ServerUtilities.LOGGER.info("Backed up {} regions containing {} claimed chunks", new Object[]{regionFiles, savedChunks});
        }
        for (File file : files) {
            ThreadBackup.compressFile(FileUtils.getRelativePath(file), file, compressor, index++, totalFiles);
        }
    }

    private static Object2ObjectMap<File, ObjectSet<ChunkDimPos>> mapClaimsToRegionFile(Set<ChunkDimPos> chunksToBackup) {
        Int2ObjectOpenHashMap regionClaimsByDim = new Int2ObjectOpenHashMap();
        chunksToBackup.forEach(arg_0 -> ThreadBackup.lambda$mapClaimsToRegionFile$3((Int2ObjectMap)regionClaimsByDim, arg_0));
        Object2ObjectOpenHashMap regionFilesToBackup = new Object2ObjectOpenHashMap();
        for (WorldServer worldserver : ServerUtils.getServer().field_71305_c) {
            File[] regions;
            if (worldserver == null) continue;
            int dim = worldserver.field_73011_w.field_76574_g;
            File regionFolder = new File(worldserver.getChunkSaveLocation(), "region");
            Long2ObjectMap regionClaims = (Long2ObjectMap)regionClaimsByDim.get(dim);
            if (!regionFolder.exists() || regionClaims == null || (regions = regionFolder.listFiles()) == null) continue;
            for (File file : regions) {
                int[] coords = ThreadBackup.getRegionCoords(file);
                if (coords == null) continue;
                long key = CoordinatePacker.pack((int)coords[0], (int)0, (int)coords[1]);
                ObjectSet claims = (ObjectSet)regionClaims.get(key);
                if (claims == null) {
                    if (!ServerUtilitiesConfig.debugging.print_more_info) continue;
                    ServerUtilities.LOGGER.info("Skipping region file {} from dimension {}", new Object[]{file.getName(), dim});
                    continue;
                }
                regionFilesToBackup.put((Object)file, (Object)claims);
            }
        }
        return regionFilesToBackup;
    }

    private static int[] getRegionCoords(File file) {
        if (!file.getName().endsWith(".mca")) {
            return null;
        }
        String[] parts = file.getName().split("\\.");
        try {
            int x = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            return new int[]{x, z};
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    private static String getDoneTime(long l) {
        return StringUtils.getTimeString(System.currentTimeMillis() - l);
    }

    private static long getRegionFromChunk(int chunkX, int chunkZ) {
        return CoordinatePacker.pack((int)(chunkX >> 5), (int)0, (int)(chunkZ >> 5));
    }

    private static /* synthetic */ void lambda$mapClaimsToRegionFile$3(Int2ObjectMap regionClaimsByDim, ChunkDimPos pos) {
        ((ObjectSet)((Long2ObjectMap)regionClaimsByDim.computeIfAbsent(pos.dim, k -> new Long2ObjectOpenHashMap())).computeIfAbsent(ThreadBackup.getRegionFromChunk(pos.posX, pos.posZ), k -> new ObjectOpenHashSet())).add((Object)pos);
    }
}

