/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.interfaces;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class GuiTextField
extends Gui {
    private int xSize;
    private int ySize;
    private int x;
    private int y;
    private String text;
    private FontRenderer fontRenderer;
    private int cursorPos = 0;
    private boolean toggleCursor;
    private Timer timer = new Timer();

    public GuiTextField(int width, int height, int x, int y) {
        this.x = x;
        this.y = y;
        this.xSize = width;
        this.ySize = height;
        this.text = "";
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.timer.scheduleAtFixedRate((TimerTask)new ToggleCursor(), 0L, 300L);
    }

    protected void setText(String text) {
        this.text = text;
    }

    protected void fixCursorPos() {
        this.cursorPos = this.text.length();
    }

    public String getText() {
        return this.text;
    }

    public void keyTyped(char c, int keycode) {
        if (Character.isLetterOrDigit(c)) {
            if (this.cursorPos != this.text.length()) {
                this.setText(this.text.substring(0, this.cursorPos) + c + this.text.substring(this.cursorPos));
            } else {
                this.setText(this.text + c);
            }
            ++this.cursorPos;
        } else {
            switch (keycode) {
                case 14: {
                    if (this.text.length() <= 0) break;
                    if (this.cursorPos == this.text.length()) {
                        this.setText(this.text.substring(0, this.cursorPos - 1));
                    } else if (this.cursorPos > 1) {
                        this.setText(this.text.substring(0, this.cursorPos - 1) + this.text.substring(this.cursorPos));
                    } else if (this.cursorPos == 1) {
                        this.setText(this.text.substring(1));
                    }
                    if (this.cursorPos <= 0) break;
                    --this.cursorPos;
                    break;
                }
                case 211: {
                    if (this.text.length() <= 0) break;
                    if (this.cursorPos == 0) {
                        this.setText(this.text.substring(1));
                        break;
                    }
                    if (this.cursorPos <= 0 || this.cursorPos >= this.text.length()) break;
                    this.setText(this.text.substring(0, this.cursorPos) + this.text.substring(this.cursorPos + 1));
                    break;
                }
                case 57: {
                    if (this.cursorPos <= this.text.length()) {
                        ++this.cursorPos;
                    }
                    this.setText(this.text + " ");
                    break;
                }
                case 203: {
                    if (this.cursorPos <= 0) break;
                    --this.cursorPos;
                    break;
                }
                case 205: {
                    if (this.cursorPos >= this.text.length()) break;
                    ++this.cursorPos;
                    break;
                }
                case 199: {
                    this.cursorPos = 0;
                    break;
                }
                case 207: {
                    this.cursorPos = this.text.length();
                    break;
                }
            }
        }
    }

    public void draw() {
        this.drawBackground();
        this.drawText();
    }

    private void drawBackground() {
        GuiTextField.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.xSize + 1), (int)(this.y + this.ySize + 1), (int)-3204833);
        GuiTextField.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.xSize), (int)(this.y + this.ySize), (int)-16777216);
    }

    public String getPreCursor() {
        return this.getText().substring(0, this.cursorPos);
    }

    public String getPostCursor() {
        return this.getText().substring(this.cursorPos);
    }

    public void drawText() {
        String preCursor = this.getPreCursor();
        this.fontRenderer.func_78276_b(preCursor, this.x + 2, this.y + this.ySize / 2 - 4, 0xE0E0E0);
        int x = this.x + 2 + this.fontRenderer.func_78256_a(preCursor);
        if (this.toggleCursor) {
            GuiTextField.func_73734_a((int)x, (int)(this.y + this.ySize / 2 - 4), (int)(x + 1), (int)(this.y + this.ySize / 2 + 4), (int)-2039584);
        }
        this.fontRenderer.func_78276_b(this.getPostCursor(), x + 2, this.y + this.ySize / 2 - 4, 0xE0E0E0);
    }

    public void close() {
        this.timer.cancel();
    }

    private class ToggleCursor
    extends TimerTask {
        private ToggleCursor() {
        }

        @Override
        public void run() {
            GuiTextField.this.toggleCursor = !GuiTextField.this.toggleCursor;
        }
    }
}

