/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.BlockCoord;
import vswe.stevescarts.Modules.Addons.ModuleAddon;
import vswe.stevescarts.Modules.Workers.Tools.ModuleDrill;

public class ModuleOreTracker
extends ModuleAddon {
    public ModuleOreTracker(MinecartModular cart) {
        super(cart);
    }

    public BlockCoord findBlockToMine(ModuleDrill drill, BlockCoord start) {
        return this.findBlockToMine(drill, new ArrayList<BlockCoord>(), start, true);
    }

    private BlockCoord findBlockToMine(ModuleDrill drill, ArrayList<BlockCoord> checked, BlockCoord current, boolean first) {
        if (current == null || checked.contains(current) || !first && !this.isOre(current)) {
            return null;
        }
        checked.add(current);
        if (checked.size() < 200) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockCoord ret;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || (ret = this.findBlockToMine(drill, checked, new BlockCoord(current.getX() + x, current.getY() + y, current.getZ() + z), false)) == null) continue;
                        return ret;
                    }
                }
            }
        }
        if (first && !this.isOre(current)) {
            return null;
        }
        if (drill.isValidBlock(current.getX(), current.getY(), current.getZ(), 0, 1, true) == null) {
            return null;
        }
        return current;
    }

    private boolean isOre(BlockCoord coord) {
        Block b = this.getCart().field_70170_p.func_147439_a(coord.getX(), coord.getY(), coord.getZ());
        if (b != null) {
            if (b instanceof BlockOre) {
                return true;
            }
            int oreId = OreDictionary.getOreID((ItemStack)new ItemStack(b));
            if (oreId == -1) {
                return false;
            }
            String oreName = OreDictionary.getOreName((int)oreId);
            return oreName.startsWith("ore");
        }
        return false;
    }
}

