/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.entities.EntityEldritchOrbAttack;
import taintedmagic.common.handler.ConfigHandler;
import taintedmagic.common.helper.TaintedMagicHelper;
import taintedmagic.common.items.wand.foci.ItemFocusTaint;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusEldritch
extends ItemFocusBasic {
    public static FocusUpgradeType sanity = new FocusUpgradeType(57, new ResourceLocation("taintedmagic", "textures/foci/IconSanity.png"), "focus.upgrade.sanity.name", "focus.upgrade.sanity.text", new AspectList().add(Aspect.MIND, 1).add(Aspect.HEAL, 1));
    IIcon depthIcon = null;
    private final AspectList costBase = new AspectList().add(Aspect.ENTROPY, 250).add(Aspect.AIR, 150).add(Aspect.FIRE, 250);
    private final AspectList costSane = new AspectList().add(Aspect.ORDER, 100).add(Aspect.WATER, 80);
    private final AspectList costCorrosive = new AspectList().add(Aspect.ENTROPY, 150).add(Aspect.FIRE, 120);

    public ItemFocusEldritch() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusEldritch");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (ConfigHandler.eldritchStaffMultiple != 1.0f) {
            list = TaintedMagicHelper.addTooltipDamageAndStaffMultiplier(list, ConfigHandler.eldritchBaseDamage, stack, ConfigHandler.eldritchStaffMultiple);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusEldritch");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusEldritch_depth");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack stack) {
        return this.depthIcon;
    }

    public String getSortingHelper(ItemStack stack) {
        return "ELDRITCH" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 24;
    }

    public AspectList getVisCost(ItemStack stack) {
        AspectList list = this.costBase.copy();
        if (TaintedMagicHelper.hasFocusUpgrade(stack, ItemFocusTaint.corrosive)) {
            list.add(this.costCorrosive);
        }
        if (TaintedMagicHelper.hasFocusUpgrade(stack, sanity)) {
            list.add(this.costSane);
        }
        return list;
    }

    public int getActivationCooldown(ItemStack stack) {
        return 1000;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (!world.field_72995_K && wand != null && wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false)) {
            int randomInt;
            EntityEldritchOrbAttack orb = new EntityEldritchOrbAttack(world, (EntityLivingBase)player, this.isUpgradedWith(wand.getFocusItem(stack), ItemFocusTaint.corrosive));
            orb.dmg = TaintedMagicHelper.getFocusDamageWithPotency(stack, ConfigHandler.eldritchBaseDamage, ConfigHandler.eldritchStaffMultiple);
            world.func_72838_d((Entity)orb);
            if (!this.isUpgradedWith(wand.getFocusItem(stack), sanity) && (randomInt = world.field_73012_v.nextInt(10)) == 5) {
                Thaumcraft.addStickyWarpToPlayer((EntityPlayer)player, (int)1);
            }
            world.func_72956_a((Entity)player, "thaumcraft:egattack", 0.4f, 1.0f + world.field_73012_v.nextFloat() * 0.1f);
        }
        player.func_71038_i();
        return stack;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: 
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, ItemFocusTaint.corrosive};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, sanity};
            }
        }
        return null;
    }
}

