/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.glease.tc4tweak.ConfigurationHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.research.ResearchCategories;

public class CommonUtils {
    private static final LinkedHashSet<String> originalTabOrders = new LinkedHashSet();

    public static String toString(AspectList al) {
        return al.aspects.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).map(e -> String.format("%dx%s", e.getValue(), ((Aspect)e.getKey()).getName())).collect(Collectors.joining(";"));
    }

    public static String toString(CrucibleRecipe r) {
        return "CrucibleRecipe{key=" + r.key + ",catalyst=" + r.catalyst + ",output=" + r.getRecipeOutput() + ",aspects=" + CommonUtils.toString(r.aspects) + "}";
    }

    static void sortResearchCategories(boolean force) {
        if (force || !ConfigurationHandler.INSTANCE.getCategoryOrder().isEmpty()) {
            LinkedHashMap categories = ResearchCategories.researchCategories;
            originalTabOrders.addAll(categories.keySet());
            LinkedHashSet<String> realOrder = new LinkedHashSet<String>(ConfigurationHandler.INSTANCE.getCategoryOrder());
            realOrder.addAll(originalTabOrders);
            LinkedHashMap newCategories = new LinkedHashMap();
            for (String tab : realOrder) {
                if (!categories.containsKey(tab)) continue;
                newCategories.put(tab, categories.get(tab));
            }
            ResearchCategories.researchCategories = newCategories;
        }
    }

    public static <T> T reflectGet(Field f, Object instance) {
        try {
            return (T)f.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName, int index) {
        try {
            Field f = null;
            Field[] fields = clazz.getDeclaredFields();
            if (index >= 0 && fields.length > index) {
                f = fields[index];
            }
            if (f == null || !f.getName().equalsIgnoreCase(fieldName)) {
                f = clazz.getDeclaredField(fieldName);
            }
            f.setAccessible(true);
            return f;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> T deref(Reference<T> ref) {
        return ref == null ? null : (T)ref.get();
    }

    public static int clamp(int val, int min, int max) {
        return Math.min(Math.max(min, val), max);
    }

    public static boolean isChunkLoaded(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return !world.func_72938_d(x, z).func_76621_g();
        }
        return world.func_72899_e(x, y, z);
    }

    public static void sendSupplementaryS35(TileEntity te) {
        if (!ConfigurationHandler.INSTANCE.isSendSupplementaryS35()) {
            return;
        }
        World w = te.func_145831_w();
        if (w.field_72995_K) {
            return;
        }
        Packet packet = te.func_145844_m();
        if (packet == null) {
            return;
        }
        int viewDistance = MinecraftServer.func_71276_C().func_71203_ab().func_72395_o();
        int sendDistanceLo = viewDistance - 2;
        int sendDistanceHi = viewDistance + 4;
        for (Object o : w.field_73010_i) {
            if (!(o instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)o;
            int dx = ((int)player.field_70165_t >> 4) - (te.field_145851_c >> 4);
            int dz = ((int)player.field_70161_v >> 4) - (te.field_145849_e >> 4);
            int dist = Math.max(Math.abs(dx), Math.abs(dz));
            if (dist < sendDistanceLo || dist > sendDistanceHi) continue;
            player.field_71135_a.func_147359_a(packet);
        }
    }
}

