/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.api.infusionrecipe;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.glease.tc4tweak.api.infusionrecipe.EnhancedInfusionRecipe;
import net.glease.tc4tweak.api.infusionrecipe.InfusionRecipeExt;
import net.glease.tc4tweak.api.infusionrecipe.RecipeIngredient;
import net.glease.tc4tweak.api.infusionrecipe.Utility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.StringUtils;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;

class InfusionRecipeExtImpl
implements InfusionRecipeExt {
    static final InfusionRecipeExtImpl INSTANCE = new InfusionRecipeExtImpl();
    private static final LoadingCache<InfusionRecipe, EnhancedInfusionRecipe> conversionCache = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().build((CacheLoader)new CacheLoader<InfusionRecipe, EnhancedInfusionRecipe>(){

        public EnhancedInfusionRecipe load(InfusionRecipe key) {
            List<RecipeIngredient> components;
            ItemStack[] rawComponents = key.getComponents();
            if (rawComponents == null) {
                components = Collections.emptyList();
            } else {
                components = new ArrayList();
                for (ItemStack rawComponent : rawComponents) {
                    components.add(Utility.convertUnderCurrentRule(rawComponent));
                }
            }
            return new EnhancedInfusionRecipe(key.getResearch(), key.getRecipeOutput(), key.getInstability(), key.getAspects(), Utility.convertUnderCurrentRule(key.getRecipeInput()), components);
        }
    });

    InfusionRecipeExtImpl() {
    }

    @Override
    @Deprecated
    public EnhancedInfusionRecipe addInfusionCraftingRecipe(String research, ItemStack result, int instability, AspectList aspects, Object input, Object ... recipe) {
        return this.addInfusionCraftingRecipe(research, result, instability, aspects, InfusionRecipeExtImpl.map(input), (RecipeIngredient[])Arrays.stream(recipe).map(InfusionRecipeExtImpl::map).toArray(RecipeIngredient[]::new));
    }

    private static RecipeIngredient map(Object thing) {
        if (thing instanceof RecipeIngredient) {
            return (RecipeIngredient)thing;
        }
        if (thing instanceof ItemStack) {
            return RecipeIngredient.item(false, (ItemStack)thing);
        }
        if (thing instanceof ItemStack[]) {
            return RecipeIngredient.items(false, (ItemStack[])thing);
        }
        if (thing instanceof String) {
            return RecipeIngredient.oredict((String)thing);
        }
        if (thing instanceof Object[]) {
            return Arrays.stream((Object[])thing).map(InfusionRecipeExtImpl::map).reduce(RecipeIngredient::or).orElseThrow(() -> new IllegalArgumentException("Infusion recipe given an empty array"));
        }
        throw new IllegalArgumentException("Not a recipe ingredient: " + thing);
    }

    @Override
    @Deprecated
    public EnhancedInfusionRecipe addInfusionCraftingRecipe(String research, ItemStack result, int instability, AspectList aspects, RecipeIngredient input, RecipeIngredient ... recipe) {
        if (result == null || result.func_77973_b() == null || result.field_77994_a <= 0) {
            throw new IllegalArgumentException("result");
        }
        return InfusionRecipeExtImpl.addInfusionCraftingRecipe(research, result, instability, aspects, input, recipe);
    }

    @Override
    @Deprecated
    public EnhancedInfusionRecipe addInfusionCraftingRecipeAddTag(String research, String label, NBTBase tag, int instability, AspectList aspects, RecipeIngredient input, RecipeIngredient ... recipe) {
        if (StringUtils.func_151246_b((String)label)) {
            throw new IllegalArgumentException("label");
        }
        if (tag == null) {
            throw new IllegalArgumentException("tag");
        }
        return InfusionRecipeExtImpl.addInfusionCraftingRecipe(research, new Object[]{label, tag}, instability, aspects, input, recipe);
    }

    @Override
    public EnhancedInfusionRecipe convert(InfusionRecipe recipe) {
        if (recipe instanceof EnhancedInfusionRecipe) {
            return (EnhancedInfusionRecipe)recipe;
        }
        return (EnhancedInfusionRecipe)((Object)conversionCache.getUnchecked((Object)recipe));
    }

    private static EnhancedInfusionRecipe addInfusionCraftingRecipe(String research, Object output, int instability, AspectList aspects, RecipeIngredient input, RecipeIngredient[] recipe) {
        if (aspects == null) {
            throw new IllegalArgumentException("aspects");
        }
        if (input == null) {
            throw new IllegalArgumentException("input");
        }
        if (recipe == null || recipe.length == 0 || Arrays.stream(recipe).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("recipe");
        }
        EnhancedInfusionRecipe r = new EnhancedInfusionRecipe(research, output, instability, aspects, input, Arrays.asList(recipe));
        InfusionRecipeExtImpl.getCraftingRecipes().add((Object)r);
        return r;
    }

    private static List<Object> getCraftingRecipes() {
        List recipes = ThaumcraftApi.getCraftingRecipes();
        return recipes;
    }
}

