/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class EntityUtilsVisitor
extends ClassVisitor {
    public static final String TARGET_CLASS_INTERNAL_NAME = "net/glease/tc4tweak/asm/ConfigurationAttributeModifier";
    public static final String ORIGINAL_CLASS_INTERNAL_NAME = "net/minecraft/entity/ai/attributes/AttributeModifier";

    public EntityUtilsVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<clinit>")) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new CLInitVisitor(this.api, mv);
        }
        return mv;
    }

    private static class CLInitVisitor
    extends MethodVisitor {
        public CLInitVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187 && type.equals(EntityUtilsVisitor.ORIGINAL_CLASS_INTERNAL_NAME)) {
                TC4Transformer.log.trace("Changed NEW from {} to {}", new Object[]{EntityUtilsVisitor.ORIGINAL_CLASS_INTERNAL_NAME, EntityUtilsVisitor.TARGET_CLASS_INTERNAL_NAME});
                type = EntityUtilsVisitor.TARGET_CLASS_INTERNAL_NAME;
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 183 && owner.equals(EntityUtilsVisitor.ORIGINAL_CLASS_INTERNAL_NAME) && name.equals("<init>")) {
                TC4Transformer.log.trace("Changed <init> owner from {} to {}", new Object[]{EntityUtilsVisitor.ORIGINAL_CLASS_INTERNAL_NAME, EntityUtilsVisitor.TARGET_CLASS_INTERNAL_NAME});
                owner = EntityUtilsVisitor.TARGET_CLASS_INTERNAL_NAME;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

