/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.researchBrowser;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import net.glease.tc4tweak.ClientUtils;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.modules.researchBrowser.DrawResearchBrowserBorders;
import net.glease.tc4tweak.modules.researchBrowser.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.gui.GuiResearchBrowser;

public class DrawResearchCompletionCounter {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
    }

    private static boolean canUnlockResearch(ResearchItem res) {
        ResearchItem parent;
        String playerName = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        if (res.parents != null) {
            for (String pt : res.parents) {
                parent = ResearchCategories.getResearch((String)pt);
                if (parent == null || ((ArrayList)GuiResearchBrowser.completedResearch.get(playerName)).contains(parent.key)) continue;
                return false;
            }
        }
        if (res.parentsHidden != null) {
            for (String pt : res.parentsHidden) {
                parent = ResearchCategories.getResearch((String)pt);
                if (parent == null || ((ArrayList)GuiResearchBrowser.completedResearch.get(playerName)).contains(parent.key)) continue;
                return false;
            }
        }
        return true;
    }

    static void drawCompletionCounter(GuiResearchBrowser gui, int x, int y, int mx, int my) {
        ConfigurationHandler.CompletionCounterStyle style = ConfigurationHandler.INSTANCE.getResearchCounterStyle();
        if (style == ConfigurationHandler.CompletionCounterStyle.None) {
            return;
        }
        ResearchCategoryList category = ResearchCategories.getResearchList((String)Utils.getActiveCategory());
        Map<String, ResearchItem> all = category.research.entrySet().stream().filter(e -> !((ResearchItem)e.getValue()).isAutoUnlock() || !((ResearchItem)e.getValue()).isVirtual()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        int total = all.size();
        ArrayList completedKeys = (ArrayList)GuiResearchBrowser.completedResearch.get(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        long completed = completedKeys.stream().filter(all::containsKey).count();
        long revealed = all.entrySet().stream().filter(e -> completedKeys.contains(e.getKey()) || completedKeys.contains("@" + (String)e.getKey()) || !((ResearchItem)e.getValue()).isLost() && (!((ResearchItem)e.getValue()).isHidden() || completedKeys.contains("@" + ((ResearchItem)e.getValue()).key)) && (!((ResearchItem)e.getValue()).isConcealed() || DrawResearchCompletionCounter.canUnlockResearch((ResearchItem)e.getValue()))).count();
        String tooltip = style == ConfigurationHandler.CompletionCounterStyle.Current && revealed < (long)total ? I18n.func_135052_a((String)"tc4tweaks.gui.progress.partial", (Object[])new Object[]{completed, revealed}) : I18n.func_135052_a((String)"tc4tweaks.gui.progress", (Object[])new Object[]{completed, total});
        FontRenderer fontRenderer = gui.field_146297_k.field_71466_p;
        int lblX = x + 16 + 2;
        int lblY = y + (17 - fontRenderer.field_78288_b) / 2;
        fontRenderer.func_85187_a(tooltip, lblX, lblY, 0x777777, true);
        if (mx >= lblX && mx <= lblX + fontRenderer.func_78256_a(tooltip) && my >= lblY && my <= lblY + fontRenderer.field_78288_b) {
            String hover = revealed < (long)total ? I18n.func_135052_a((String)"tc4tweaks.gui.progress.partial.tooltip", (Object[])new Object[0]) : I18n.func_135052_a((String)"tc4tweaks.gui.progress.tooltip", (Object[])new Object[0]);
            ClientUtils.drawMultilineTip(fontRenderer, mx, my, Collections.singletonList(hover));
        }
    }

    public static enum EventHandler {
        INSTANCE;


        @SubscribeEvent
        public void onPostGuiDraw(GuiScreenEvent.DrawScreenEvent.Post e) {
            if (!(e.gui instanceof GuiResearchBrowser)) {
                return;
            }
            DrawResearchCompletionCounter.drawCompletionCounter((GuiResearchBrowser)e.gui, DrawResearchBrowserBorders.guiX, DrawResearchBrowserBorders.guiY, e.mouseX, e.mouseY);
        }
    }
}

