/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.thaumicexploration.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.VisNetHandler;

public class TileEntityEverburnUrn
extends TileEntity
implements IFluidTank,
IFluidHandler {
    private int ticks = 0;
    public float ignisVis;
    public static int CONVERSION_FACTOR = 250;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.ignisVis = nbttagcompound.func_74760_g("ignisVis");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74776_a("ignisVis", this.ignisVis);
    }

    public FluidStack getFluid() {
        return new FluidStack(FluidRegistry.LAVA, this.getFluidAmount());
    }

    public int getFluidAmount() {
        return (int)Math.floor(this.ignisVis * (float)CONVERSION_FACTOR);
    }

    public int getCapacity() {
        return 4 * CONVERSION_FACTOR;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        float drained = Math.min(maxDrain, this.getFluidAmount());
        if (doDrain) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.ignisVis -= drained / 250.0f;
        }
        return new FluidStack(FluidRegistry.LAVA, (int)drained);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!resource.isFluidEqual(new FluidStack(FluidRegistry.LAVA, 1)) || from != ForgeDirection.UP) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UP) {
            return this.drain(maxDrain, doDrain);
        }
        return new FluidStack(FluidRegistry.LAVA, 0);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    public void func_145845_h() {
        super.func_145845_h();
        ++this.ticks;
        if (this.ticks == 10) {
            if (this.ignisVis < 16.0f) {
                this.ignisVis += (float)VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Aspect)Aspect.FIRE, (int)1);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.ticks = 0;
        }
    }
}

