/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IMultiWarpEvent;
import shukaro.warptheory.net.PacketDispatcher;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.RandomBlockHelper;

public class WarpBlood
extends IMultiWarpEvent {
    public static ListMultimap<Integer, BlockCoord> bloody = MultimapBuilder.hashKeys().arrayListValues().build();
    public static ListMultimap<Integer, BlockCoord> blackBloody = MultimapBuilder.hashKeys().arrayListValues().build();

    public WarpBlood(int minWarp) {
        super("blood", minWarp, 2, world -> 64 + world.field_73012_v.nextInt(128));
    }

    @Override
    public int triggerEvent(int eventLevel, int eventAmount, World world, EntityPlayer player) {
        int successful = 0;
        for (int i = 0; i < 6; ++i) {
            BlockCoord target = RandomBlockHelper.randomBlock(world, player, 8, block -> WarpBlood.isBlockValid(world, block));
            if (target == null) continue;
            PacketDispatcher.sendBloodEvent(player, eventLevel, target.x, target.y + 1, target.z);
            if (++successful < eventAmount) continue;
            PacketDispatcher.sendBloodClearEvent(player);
            break;
        }
        return successful;
    }

    private static boolean isBlockValid(World world, BlockCoord block) {
        return world.func_147437_c(block.x, block.y - 1, block.z) && !block.isAir((IBlockAccess)world) && world.func_147439_a(block.x, block.y, block.z).func_149688_o().func_76230_c();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world.func_82737_E() % 5L == 0L && bloody.get((Object)world.field_73011_w.field_76574_g) != null) {
            for (BlockCoord c : bloody.get((Object)world.field_73011_w.field_76574_g)) {
                MiscHelper.spawnDripParticle((World)world, c.x, c.y, c.z, world.field_73012_v.nextFloat() + 0.2f, 0.0f, 0.0f);
            }
            for (BlockCoord c : blackBloody.get((Object)world.field_73011_w.field_76574_g)) {
                MiscHelper.spawnDripParticle((World)world, c.x, c.y, c.z, 0.0f, 0.0f, 0.0f);
            }
        }
    }
}

