/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.warptheory.entity.EntityPhantom;
import shukaro.warptheory.handlers.IWorldTickWarpEvent;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.RandomBlockHelper;

public class WarpPhantoms
extends IWorldTickWarpEvent {
    public WarpPhantoms(int minWarp) {
        super("phantoms", minWarp, world -> 1 + world.field_73012_v.nextInt(5));
    }

    @Override
    public void sendChatMessage(EntityPlayer player) {
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        int successful = 0;
        for (int i = 0; i < 6; ++i) {
            BlockCoord target = RandomBlockHelper.randomBlock(world, player, 32, block -> WarpPhantoms.isValid(world, block));
            if (target == null) continue;
            EntityPhantom phantom = new EntityPhantom(world);
            RandomBlockHelper.setLocation(world, (Entity)phantom, target);
            if (world.func_72838_d((Entity)phantom) && ++successful >= eventAmount) break;
        }
        return successful;
    }

    private static boolean isValid(World world, BlockCoord block) {
        BlockCoord below = block.copy().offset(0);
        BlockCoord above = block.copy().offset(1);
        return below.isTopSolid((IBlockAccess)world) && block.isAir((IBlockAccess)world) && above.isAir((IBlockAccess)world);
    }
}

