/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWorldTickWarpEvent;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.RandomBlockHelper;

public class WarpWither
extends IWorldTickWarpEvent {
    public WarpWither(int minWarp) {
        super("wither", minWarp, world -> 1);
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        BlockCoord target = RandomBlockHelper.randomBlock(world, player, 4, block -> WarpWither.isValid(world, block));
        if (target == null) {
            return 0;
        }
        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)target.x, (double)target.y, (double)target.z));
        world.func_72908_a((double)target.x, (double)target.y, (double)target.z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        world.func_72869_a("hugeexplosion", (double)target.x, (double)target.y, (double)target.z, 1.0, 0.0, 0.0);
        EntityWither wither = new EntityWither(world);
        wither.func_70012_b((double)target.x + 0.5, (double)target.y - 0.5, (double)target.z + 0.5, world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat());
        wither.func_82206_m();
        if (world.func_72838_d((Entity)wither)) {
            return 1;
        }
        return 0;
    }

    private static boolean isValid(World world, BlockCoord block) {
        if (!world.func_147439_a(block.x, block.y - 1, block.z).func_149688_o().func_76230_c()) {
            return false;
        }
        for (int xb = block.x - 1; xb < block.x + 1; ++xb) {
            for (int yb = block.y; yb < block.y + 2; ++yb) {
                for (int zb = block.z - 1; zb < block.z + 1; ++zb) {
                    if (!world.func_147439_a(xb, yb, zb).func_149688_o().func_76230_c()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

