/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.api.plugin.base;

import alkalus.main.api.RecipeManager;
import alkalus.main.api.plugin.interfaces.WitcheryPlugin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class BasePluginWitchery
implements WitcheryPlugin {
    private volatile boolean isValid = true;

    public BasePluginWitchery(Set<LoadPhase> phases) {
        this(phases, true);
    }

    public BasePluginWitchery(LoadPhase[] phases) {
        this(new HashSet<LoadPhase>(Arrays.asList(phases)), true);
    }

    private BasePluginWitchery(Set<LoadPhase> phases, boolean internal) {
        if (phases == null || phases.size() <= 0 || phases.size() >= 4) {
            this.isValid = false;
        }
        if (this.isValid) {
            for (LoadPhase p : phases) {
                if (p == LoadPhase.PREINIT) {
                    RecipeManager.PluginManager.loadPluginForPreInit(this);
                    continue;
                }
                if (p == LoadPhase.INIT) {
                    RecipeManager.PluginManager.loadPluginForInit(this);
                    continue;
                }
                if (p != LoadPhase.POSTINIT) continue;
                RecipeManager.PluginManager.loadPluginForPostInit(this);
            }
        }
    }

    @Override
    public abstract boolean preInit();

    @Override
    public abstract boolean init();

    @Override
    public abstract boolean postInit();

    public static enum LoadPhase {
        PREINIT,
        INIT,
        POSTINIT;

    }
}

