/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.storage.ITerminalHost;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import com.glodblock.github.client.gui.container.base.FCContainerEncodeTerminal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerFluidPatternTerminalEx
extends FCContainerEncodeTerminal {
    private static final int CRAFTING_GRID_PAGES = 2;
    private static final int CRAFTING_GRID_WIDTH = 4;
    private static final int CRAFTING_GRID_HEIGHT = 4;
    private static final int CRAFTING_GRID_SLOTS = 16;

    public ContainerFluidPatternTerminalEx(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.craftingSlots = new ProcessingSlotFake[32];
        this.outputSlots = new ProcessingSlotFake[32];
        IInventory output = this.getPatternTerminal().getInventoryByName("output");
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    ProcessingSlotFake processingSlotFake = new ProcessingSlotFake(this.crafting, this, x + y * 4 + page * 16, 15, -83, x, y, x + 4);
                    this.craftingSlots[x + y * 4 + page * 16] = processingSlotFake;
                    this.func_75146_a((Slot)processingSlotFake);
                }
            }
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    ProcessingSlotFake processingSlotFake = new ProcessingSlotFake(output, this, x * 4 + y + page * 16, 112, -83, -x, y, x);
                    this.outputSlots[x * 4 + y + page * 16] = processingSlotFake;
                    this.func_75146_a((Slot)processingSlotFake);
                }
            }
        }
        this.craftingMode = false;
    }

    public boolean isSlotEnabled(int idx) {
        if (idx < 4) {
            return this.inverted || idx == 0;
        }
        return !this.inverted || idx == 4;
    }

    @Override
    protected boolean validPatternSlot(Slot slot) {
        return slot instanceof ProcessingSlotFake;
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer() && (this.inverted != this.patternTerminal.isInverted() || this.activePage != this.patternTerminal.getActivePage())) {
            this.inverted = this.patternTerminal.isInverted();
            this.activePage = this.patternTerminal.getActivePage();
            this.offsetSlots();
        }
        super.func_75142_b();
    }

    private void offsetSlots() {
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    ((ProcessingSlotFake)this.craftingSlots[x + y * 4 + page * 16]).setHidden(page != this.activePage || x > 0 && this.inverted);
                    ((ProcessingSlotFake)this.outputSlots[x * 4 + y + page * 16]).setHidden(page != this.activePage || x > 0 && !this.inverted);
                }
            }
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("inverted") || field.equals("activePage")) {
            this.offsetSlots();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            this.inverted = this.patternTerminal.isInverted();
        }
        super.onSlotChange(s);
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        this.craftingMode = false;
        super.doAction(player, action, slotId, id);
    }

    @Override
    public void encode() {
        this.craftingMode = false;
        super.encode();
    }

    @Override
    public boolean isCraftingMode() {
        return false;
    }

    private static class ProcessingSlotFake
    extends OptionalSlotFake {
        private static final int POSITION_SHIFT = 9000;
        private boolean hidden = false;

        public ProcessingSlotFake(IInventory inv, IOptionalSlotHost containerBus, int idx, int x, int y, int offX, int offY, int groupNum) {
            super(inv, containerBus, idx, x, y, offX, offY, groupNum);
            this.setRenderDisabled(false);
        }

        public void setHidden(boolean hide) {
            if (this.hidden != hide) {
                this.hidden = hide;
                this.field_75223_e += (hide ? -1 : 1) * 9000;
            }
        }
    }
}

