/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.data.IAEFluidStack;
import appeng.client.texture.CableBusTextures;
import appeng.helpers.IInterfaceHost;
import appeng.parts.misc.PartInterface;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.util.Platform;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.AEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import com.glodblock.github.inventory.IDualHost;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.DualityFluidInterface;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class PartFluidInterface
extends PartInterface
implements IDualHost {
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 6);
    private final DualityFluidInterface fluidDuality = new DualityFluidInterface(this.getProxy(), (IInterfaceHost)this);

    public PartFluidInterface(ItemStack is) {
        super(is);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, (IBoxProvider)this, this.getRenderCache()));
        rh.setTexture(CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), FCPartsTexture.BlockInterface_Face.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), FCPartsTexture.BlockInterface_Face.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon());
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), FCPartsTexture.BlockInterface_Face.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), FCPartsTexture.BlockInterface_Face.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.fluidDuality.onChannelStateChange(c);
        super.stateChange(c);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.fluidDuality.onPowerStateChange(c);
        super.stateChange(c);
    }

    public void gridChanged() {
        super.gridChanged();
        this.fluidDuality.gridChanged();
    }

    @Override
    public DualityFluidInterface getDualityFluid() {
        return this.fluidDuality;
    }

    @Override
    public AEFluidInventory getInternalFluid() {
        return this.fluidDuality.getTanks();
    }

    @Override
    public AppEngInternalAEInventory getConfig() {
        Util.mirrorFluidToPacket((IInventory)this.config, this.fluidDuality.getConfig());
        return this.config;
    }

    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        for (int i = 0; i < this.config.func_70302_i_(); ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.config.func_70301_a(i));
        }
        this.getInternalFluid().writeToBuf(data);
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        boolean changed = false;
        for (int i = 0; i < this.config.func_70302_i_(); ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)data);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.config.func_70301_a(i))) continue;
            this.config.func_70299_a(i, stack);
            changed = true;
        }
        this.fluidDuality.loadConfigFromPacket((IInventory)this.config);
        return changed |= this.getInternalFluid().readFromBuf(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.config.readFromNBT(data, "ConfigInv");
        this.fluidDuality.loadConfigFromPacket((IInventory)this.config);
        this.getInternalFluid().readFromNBT(data, "FluidInv");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.config.writeToNBT(data, "ConfigInv");
        this.getInternalFluid().writeToNBT(data, "FluidInv");
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.getInterfaceDuality().getInstalledUpgrades(u);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fluidDuality.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.fluidDuality.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.fluidDuality.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluidDuality.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.fluidDuality.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.fluidDuality.getTankInfo(from);
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (player.func_70093_af()) {
            return false;
        }
        if (Platform.isServer()) {
            InventoryHandler.openGui(player, this.getHost().getTile().func_145831_w(), new BlockPos(this.getHost().getTile()), Objects.requireNonNull(this.getSide()), GuiType.DUAL_INTERFACE);
        }
        return true;
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.saveChanges();
        this.getTileEntity().func_70296_d();
        this.fluidDuality.onFluidInventoryChanged(inv, slot);
    }

    @Override
    public void setConfig(int id, IAEFluidStack fluid) {
        if (id >= 0 && id < 6) {
            this.config.func_70299_a(id, ItemFluidPacket.newDisplayStack(fluid == null ? null : fluid.getFluidStack()));
            this.fluidDuality.getConfig().setFluidInSlot(id, this.fluidDuality.getStandardFluid(fluid));
        }
    }

    @Override
    public void setFluidInv(int id, IAEFluidStack fluid) {
        if (id >= 0 && id < 6) {
            this.getInternalFluid().setFluidInSlot(id, fluid);
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        TickingRequest item = super.getTickingRequest(node);
        TickingRequest fluid = this.fluidDuality.getTickingRequest(node);
        return new TickingRequest(Math.min(item.minTickRate, fluid.minTickRate), Math.max(item.maxTickRate, fluid.maxTickRate), item.isSleeping && fluid.isSleeping, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        TickRateModulation item = super.tickingRequest(node, TicksSinceLastCall);
        TickRateModulation fluid = this.fluidDuality.tickingRequest(node, TicksSinceLastCall);
        if (item.ordinal() >= fluid.ordinal()) {
            return item;
        }
        return fluid;
    }
}

