/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.waila;

import appeng.api.parts.IPart;
import appeng.integration.modules.waila.part.IPartWailaDataProvider;
import appeng.integration.modules.waila.part.PartAccessor;
import appeng.integration.modules.waila.part.Tracer;
import com.glodblock.github.crossmod.waila.part.FluidInvWailaDataProvider;
import com.glodblock.github.crossmod.waila.part.FluidMonitorWailaDataProvider;
import com.glodblock.github.crossmod.waila.part.SpeedWailaDataProvider;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class PartWailaDataProvider
implements IWailaDataProvider {
    private final List<IPartWailaDataProvider> providers;
    private final PartAccessor accessor = new PartAccessor();
    private final Tracer tracer = new Tracer();

    public PartWailaDataProvider() {
        SpeedWailaDataProvider speed = new SpeedWailaDataProvider();
        FluidInvWailaDataProvider fluidInv = new FluidInvWailaDataProvider();
        FluidMonitorWailaDataProvider fluidMonitor = new FluidMonitorWailaDataProvider();
        this.providers = Lists.newArrayList((Object[])new IPartWailaDataProvider[]{speed, fluidInv, fluidMonitor});
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPartWailaDataProvider provider;
            IPart part = (IPart)maybePart.get();
            ItemStack wailaStack = null;
            Iterator<IPartWailaDataProvider> iterator = this.providers.iterator();
            while (iterator.hasNext() && (wailaStack = (provider = iterator.next()).getWailaStack(part, config, null)) == null) {
            }
            return wailaStack;
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaHead(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaBody(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition mop;
        TileEntity te = accessor.getTileEntity();
        Optional maybePart = this.accessor.getMaybePart(te, mop = accessor.getPosition());
        if (maybePart.isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaTail(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        Optional maybePart;
        MovingObjectPosition mop = this.tracer.retraceBlock(world, player, x, y, z);
        if (mop != null && (maybePart = this.accessor.getMaybePart(te, mop)).isPresent()) {
            IPart part = (IPart)maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getNBTData(player, part, te, tag, world, x, y, z);
            }
        }
        return tag;
    }
}

