/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.loader.recipe;

import appeng.api.AEApi;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IItemList;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import com.glodblock.github.loader.ItemAndBlockHolder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class DisassembleRecipe
implements IRecipe {
    private final Map<ItemStack, ItemStack> cellMappings = new HashMap<ItemStack, ItemStack>(16);
    private final Map<ItemStack, ItemStack> nonCellMappings = new HashMap<ItemStack, ItemStack>(1);

    public DisassembleRecipe() {
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL1K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 0));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL4K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 1));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL16K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 2));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL64K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 3));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL256K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 4));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL1024K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 5));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL4096K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 6));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL16384K), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 7));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL1KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 0));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL4KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 1));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL16KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 2));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL64KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 3));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL256KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 4));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL1024KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 5));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL4096KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 6));
        this.cellMappings.put(new ItemStack((Item)ItemAndBlockHolder.CELL16384KM), new ItemStack((Item)ItemAndBlockHolder.CELL_PART, 1, 7));
        this.nonCellMappings.put(new ItemStack((Item)ItemAndBlockHolder.PATTERN), (ItemStack)AEApi.instance().definitions().materials().blankPattern().maybeStack(1).get());
    }

    public boolean func_77569_a(InventoryCrafting inv, World w) {
        return this.getOutput((IInventory)inv) != null;
    }

    private ItemStack getOutput(IInventory inventory) {
        int itemCount = 0;
        ItemStack output = null;
        for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
            ItemStack craftingStorageStack;
            ItemStack stackInSlot = inventory.func_70301_a(slotIndex);
            if (stackInSlot == null) continue;
            if (++itemCount > 1) {
                return null;
            }
            ItemStack storageCellStack = this.getCellOutput(stackInSlot);
            if (storageCellStack != null) {
                IItemList list;
                IMEInventoryHandler cellInv = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, StorageChannel.FLUIDS);
                if (cellInv != null && !(list = cellInv.getAvailableItems(StorageChannel.FLUIDS.createList(), IterationCounter.fetchNewId())).isEmpty()) {
                    return null;
                }
                output = storageCellStack;
            }
            if ((craftingStorageStack = this.getNonCellOutput(stackInSlot)) == null) continue;
            output = craftingStorageStack;
        }
        return output;
    }

    private ItemStack getCellOutput(ItemStack compared) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.cellMappings.entrySet()) {
            if (!Platform.isSameItemType((ItemStack)compared, (ItemStack)entry.getKey())) continue;
            return entry.getValue().func_77946_l();
        }
        return null;
    }

    private ItemStack getNonCellOutput(ItemStack compared) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.nonCellMappings.entrySet()) {
            if (!Platform.isSameItemType((ItemStack)compared, (ItemStack)entry.getKey())) continue;
            return entry.getValue().func_77946_l();
        }
        return null;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.getOutput((IInventory)inv);
    }

    public int func_77570_a() {
        return 1;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return null;
    }
}

