/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container.base;

import appeng.api.storage.ITerminalHost;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.util.Platform;
import com.glodblock.github.inventory.item.IFluidPortableCell;
import com.glodblock.github.inventory.item.IWirelessExtendCard;
import com.glodblock.github.inventory.item.WirelessMagnet;
import com.glodblock.github.util.Util;
import net.minecraft.entity.player.InventoryPlayer;

public abstract class FCBaseContainer
extends AEBaseContainer {
    private int ticks;
    private final double powerMultiplier = 0.5;
    private ITerminalHost host;
    private int slot = -1;
    private final InventoryPlayer ip;
    @GuiSync(value=105)
    public boolean restock = false;
    @GuiSync(value=106)
    public WirelessMagnet.Mode mode = WirelessMagnet.Mode.Off;

    public FCBaseContainer(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, (Object)monitorable);
        this.ip = ip;
        this.host = monitorable;
        if (this.isWirelessTerminal()) {
            this.slot = this.lockSlot();
        }
    }

    private int lockSlot() {
        if (this.isWirelessTerminal()) {
            if (this.host instanceof IFluidPortableCell) {
                int slotIndex = ((IFluidPortableCell)this.host).getInventorySlot();
                if (Util.GuiHelper.decodeInvType(slotIndex).getLeft() == Util.GuiHelper.InvType.PLAYER_INV) {
                    this.lockPlayerInventorySlot(slotIndex);
                }
                return slotIndex;
            }
            this.lockPlayerInventorySlot(this.ip.field_70461_c);
        }
        return -1;
    }

    protected abstract boolean isWirelessTerminal();

    public void func_75142_b() {
        ITerminalHost iTerminalHost;
        if (this.isWirelessTerminal()) {
            this.ticks = Util.drainItemPower(this, this.getPlayerInv(), this.slot, this.ticks, this.getPowerMultiplier(), (IFluidPortableCell)this.host);
        }
        if (Platform.isServer() && (iTerminalHost = this.host) instanceof IWirelessExtendCard) {
            IWirelessExtendCard wec = (IWirelessExtendCard)iTerminalHost;
            this.mode = wec.getMagnetCardMode();
            this.restock = wec.isRestock();
        }
        super.func_75142_b();
    }

    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public ITerminalHost getHost() {
        return this.host;
    }

    public IFluidPortableCell getPortableCell() {
        ITerminalHost iTerminalHost = this.host;
        if (iTerminalHost instanceof IFluidPortableCell) {
            IFluidPortableCell fpc = (IFluidPortableCell)iTerminalHost;
            return fpc;
        }
        return null;
    }
}

