/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.exceptions.MissingDefinition;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.item.FCBaseItemCell;
import com.glodblock.github.common.storage.CellType;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.loader.IRegister;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemMultiFluidStorageCell
extends FCBaseItemCell
implements IStorageFluidCell,
IRegister<ItemMultiFluidStorageCell> {
    private static final HashMap<Integer, IIcon> icon = new HashMap();
    private final int housingValue;

    public ItemMultiFluidStorageCell(CellType whichCell, int housingValue, long kilobytes) {
        super((Optional<String>)Optional.of((Object)(kilobytes + "k")));
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
        this.totalBytes = kilobytes * 1024L;
        this.component = whichCell;
        this.housingValue = housingValue;
        this.maxType = 5;
        this.func_77655_b("multi_fluid_storage." + kilobytes);
        switch (this.component) {
            case Cell1kPart: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case Cell4kPart: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case Cell16kPart: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case Cell64kPart: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            case Cell256kPart: {
                this.idleDrain = 2.5;
                this.perType = 2048;
                break;
            }
            case Cell1024kPart: {
                this.idleDrain = 3.0;
                this.perType = 8192;
                break;
            }
            case Cell4096kPart: {
                this.idleDrain = 3.5;
                this.perType = 32768;
                break;
            }
            case Cell16384kPart: {
                this.idleDrain = 4.0;
                this.perType = 131072;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    public ItemStack getHousing() {
        return ItemAndBlockHolder.CELL_HOUSING.stack(1, this.housingValue);
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74837_a((String)("item.multi_fluid_storage." + this.totalBytes / 1024L + ".name"), (Object[])new Object[]{CellType.getTypeColor(this.component), EnumChatFormatting.RESET});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        icon.put((int)(this.totalBytes / 1024L), iconRegister.func_94245_a("ae2fc:multi_fluid_storage." + this.totalBytes / 1024L));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        int id = (int)(this.totalBytes / 1024L);
        return icon.get(id);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        this.disassembleDrive(stack, world, player);
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)stack, (int)1) <= 0) {
            return true;
        }
        return this.disassembleDrive(stack, world, player);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return AEConfig.instance.isFeatureEnabled(AEFeature.EnableDisassemblyCrafting);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (this.getHousing() != null) {
            return this.getHousing();
        }
        throw new MissingDefinition("Tried to use empty storage cells while basic storage cells are defined.");
    }

    @Override
    public ItemMultiFluidStorageCell register() {
        if (!Config.fluidCells) {
            return null;
        }
        GameRegistry.registerItem((Item)this, (String)("multi_fluid_storage" + this.totalBytes / 1024L), (String)"ae2fc");
        this.func_77637_a(FluidCraftingTabs.INSTANCE);
        return this;
    }
}

