/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import com.glodblock.github.inventory.AeStackInventory;
import com.glodblock.github.inventory.AeStackInventoryImpl;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileFluidPatternEncoder
extends AEBaseTile
implements IAEAppEngInventory {
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    private final AeStackInventoryImpl<IAEItemStack> crafting = new AeStackInventoryImpl(StorageChannel.ITEMS, 9, this);
    private final AeStackInventoryImpl<IAEItemStack> output = new AeStackInventoryImpl(StorageChannel.ITEMS, 3, this);

    public IInventory getInventory() {
        return this.patternInv;
    }

    public AeStackInventory<IAEItemStack> getCraftingSlots() {
        return this.crafting;
    }

    public AeStackInventory<IAEItemStack> getOutputSlots() {
        return this.output;
    }

    public boolean canBeRotated() {
        return false;
    }

    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        for (ItemStack stack : this.patternInv) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.patternInv.readFromNBT(data, "Inventory");
        this.crafting.readFromNbt(data, "CraftingSlots");
        this.output.readFromNbt(data, "OutputSlots");
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        this.patternInv.writeToNBT(data, "Inventory");
        this.crafting.writeToNbt(data, "CraftingSlots");
        this.output.writeToNbt(data, "OutputSlots");
        return data;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }
}

