/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.waila.tile;

import appeng.integration.modules.waila.BaseWailaDataProvider;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.tile.TileFluidBuffer;
import com.glodblock.github.common.tile.TileFluidInterface;
import com.glodblock.github.common.tile.TileFluidPacketDecoder;
import com.glodblock.github.crossmod.waila.Tooltip;
import com.glodblock.github.inventory.IAEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidInvWailaDataProvider
extends BaseWailaDataProvider {
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TileFluidInterface) {
            ((IAEFluidInventory)te).getInternalFluid().readFromNBT(accessor.getNBTData(), "fluidInv");
            this.addTooltip(currentToolTip, ((IAEFluidInventory)te).getInternalFluid(), true);
        } else if (te instanceof IAEFluidInventory) {
            ((IAEFluidInventory)te).getInternalFluid().readFromNBT(accessor.getNBTData(), "fluidInv");
            this.addTooltip(currentToolTip, ((IAEFluidInventory)te).getInternalFluid());
        } else if (te instanceof TileFluidPacketDecoder) {
            te.func_145839_a(accessor.getNBTData());
            IInventory inv = ((TileFluidPacketDecoder)te).getInventory();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is == null || !(is.func_77973_b() instanceof ItemFluidPacket)) continue;
                FluidStack fs = ItemFluidPacket.getFluidStack(is);
                currentToolTip.add(Tooltip.fluidFormat(fs.getLocalizedName(), fs.amount));
            }
        }
        return currentToolTip;
    }

    private void addTooltip(List<String> currentToolTip, IAEFluidTank ft, boolean prefix) {
        for (int i = 0; i < ft.getSlots(); ++i) {
            if (ft.getFluidInSlot(i) == null) continue;
            FluidStack fs = ft.getFluidInSlot(i).getFluidStack();
            if (prefix) {
                currentToolTip.add(Tooltip.tileFluidInterfaceFormat(fs.getLocalizedName(), fs.amount, i));
                continue;
            }
            currentToolTip.add(Tooltip.fluidFormat(fs.getLocalizedName(), fs.amount));
        }
    }

    private void addTooltip(List<String> currentToolTip, IAEFluidTank ft) {
        this.addTooltip(currentToolTip, ft, false);
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileFluidBuffer) {
            ((TileFluidBuffer)te).updateFluidStore();
        }
        if (te instanceof IAEFluidInventory) {
            ((IAEFluidInventory)te).getInternalFluid().writeToNBT(tag, "fluidInv");
        } else if (te instanceof TileFluidPacketDecoder) {
            te.func_145841_b(tag);
        }
        return tag;
    }
}

