/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.recipes.extractor;

import codechicken.nei.PositionedStack;
import com.glodblock.github.nei.object.IRecipeExtractor;
import com.glodblock.github.nei.object.OrderStack;
import com.glodblock.github.nei.recipes.extractor.ExtractorUtil;
import gregtech.api.enums.ItemList;
import gregtech.common.items.ItemFluidDisplay;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GregTech5RecipeExtractor
implements IRecipeExtractor {
    boolean removeSpecial;

    public GregTech5RecipeExtractor(boolean removeSpecial) {
        this.removeSpecial = removeSpecial;
    }

    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs) {
        if (this.removeSpecial) {
            this.removeSpecial(rawInputs);
        }
        return ExtractorUtil.packItemStack(rawInputs, GregTech5RecipeExtractor::getFluidFromDisplay);
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs) {
        return ExtractorUtil.packItemStack(rawOutputs, GregTech5RecipeExtractor::getFluidFromDisplay);
    }

    private void removeSpecial(List<PositionedStack> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            PositionedStack positionedStack = list.get(i);
            if (positionedStack == null || !positionedStack.items[0].func_77969_a(ItemList.Tool_DataStick.get(1L, new Object[0])) && !positionedStack.items[0].func_77969_a(ItemList.Tool_DataOrb.get(1L, new Object[0]))) continue;
            list.remove(i);
            break;
        }
    }

    public static Object getFluidFromDisplay(PositionedStack stack) {
        if (stack != null) {
            ItemStack item = stack.items[0].func_77946_l();
            if (item.func_77973_b() instanceof ItemFluidDisplay) {
                if (item.func_77978_p() != null) {
                    Fluid fluid = FluidRegistry.getFluid((int)item.func_77960_j());
                    int amt = (int)item.func_77978_p().func_74763_f("mFluidDisplayAmount");
                    return amt > 0 && fluid != null ? new FluidStack(fluid, amt) : null;
                }
            } else {
                return item;
            }
        }
        return null;
    }
}

