/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.ModItems;
import vazkii.akashictome.utils.ItemNBTHelper;

public final class MorphingHandler {
    public static final MorphingHandler INSTANCE = new MorphingHandler();
    public static final String MINECRAFT = "minecraft";
    public static final String TAG_MORPHING = "akashictome:is_morphing";
    public static final String TAG_TOME_DATA = "akashictome:data";
    public static final String TAG_TOME_DISPLAY_NAME = "akashictome:displayName";
    public static final String TAG_ITEM_DEFINED_MOD = "akashictome:definedMod";
    private static final Map<String, String> modNames = new HashMap<String, String>();

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (!event.player.func_70093_af()) {
            return;
        }
        EntityItem e = event.entityItem;
        ItemStack stack = e.func_92059_d();
        if (MorphingHandler.isMorphedTome(stack)) {
            ItemStack original;
            NBTTagCompound tome;
            NBTTagCompound morphData = (NBTTagCompound)stack.func_77978_p().func_74775_l(TAG_TOME_DATA).func_74737_b();
            String currentMod = ItemNBTHelper.getString(stack, TAG_ITEM_DEFINED_MOD, MorphingHandler.getModFromStack(stack));
            ItemStack morph = MorphingHandler.makeMorphedStack(stack, MINECRAFT, morphData);
            NBTTagCompound newMorphData = morph.func_77978_p().func_74775_l(TAG_TOME_DATA);
            newMorphData.func_82580_o(currentMod);
            if (!e.field_70170_p.field_72995_K) {
                EntityItem newItem = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, morph);
                e.field_70170_p.func_72838_d((Entity)newItem);
            }
            if ((tome = (original = stack.func_77946_l()).func_77978_p()) == null) {
                tome = new NBTTagCompound();
                original.func_77982_d(tome);
            }
            tome.func_82580_o("display");
            String displayName = tome.func_74779_i(TAG_TOME_DISPLAY_NAME);
            if (!displayName.isEmpty() && !displayName.equals(original.func_82833_r())) {
                original.func_151001_c(displayName);
            }
            tome.func_82580_o(TAG_MORPHING);
            tome.func_82580_o(TAG_TOME_DISPLAY_NAME);
            tome.func_82580_o(TAG_TOME_DATA);
            e.func_92058_a(original);
        }
    }

    public static String getModFromBlock(Block state) {
        String[] mod = state.delegate.name().split(":");
        return MorphingHandler.getModOrAlias(mod[0]);
    }

    public static String getModFromStack(@Nullable ItemStack stack) {
        if (stack == null) {
            return MINECRAFT;
        }
        String[] mod = stack.func_77973_b().delegate.name().split(":");
        return MorphingHandler.getModOrAlias(mod[0]);
    }

    public static String getModOrAlias(String mod) {
        return ConfigHandler.aliases.getOrDefault(mod, mod);
    }

    public static boolean doesStackHaveModAttached(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA);
        return morphData.func_74764_b(mod);
    }

    public static ItemStack getShiftStackForMod(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return stack;
        }
        String currentMod = MorphingHandler.getModFromStack(stack);
        if (mod.equals(currentMod)) {
            return stack;
        }
        NBTTagCompound morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA);
        return MorphingHandler.makeMorphedStack(stack, mod, morphData);
    }

    public static boolean containsItem(ItemStack tome, ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (tome.func_77942_o()) {
            NBTTagCompound data = tome.func_77978_p().func_74775_l(TAG_TOME_DATA);
            ArrayList keys = new ArrayList(data.func_150296_c());
            Collections.sort(keys);
            for (String s : keys) {
                ItemStack modStack;
                NBTTagCompound cmp = data.func_74775_l(s);
                if (cmp == null || (modStack = ItemNBTHelper.loadItemStackFromNBT(cmp)) == null) continue;
                stacks.add(modStack);
            }
        }
        return stacks.stream().anyMatch(itemStack -> itemStack.func_77969_a(stack));
    }

    public static ItemStack makeMorphedStack(ItemStack currentStack, String targetMod, NBTTagCompound morphData) {
        ItemStack stack;
        String currentMod = ItemNBTHelper.getString(currentStack, TAG_ITEM_DEFINED_MOD, MorphingHandler.getModFromStack(currentStack));
        NBTTagCompound currentCmp = ItemNBTHelper.saveItemStackToNBT(currentStack);
        if (currentCmp.func_74764_b("tag")) {
            currentCmp.func_74775_l("tag").func_82580_o(TAG_TOME_DATA);
        }
        if (!currentMod.equalsIgnoreCase(MINECRAFT) && !currentMod.equalsIgnoreCase("akashictome")) {
            morphData.func_74782_a(currentMod, (NBTBase)currentCmp);
        }
        if (targetMod.equals(MINECRAFT)) {
            stack = new ItemStack(ModItems.tome);
        } else {
            NBTTagCompound targetCmp = morphData.func_74775_l(targetMod);
            morphData.func_82580_o(targetMod);
            stack = ItemNBTHelper.loadItemStackFromNBT(targetCmp);
            if (stack == null) {
                stack = new ItemStack(ModItems.tome);
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound stackCmp = stack.func_77978_p();
        stackCmp.func_74782_a(TAG_TOME_DATA, (NBTBase)morphData);
        stackCmp.func_74757_a(TAG_MORPHING, true);
        if (stack.func_77973_b() != ModItems.tome) {
            String displayName = stack.func_82833_r();
            if (stackCmp.func_74764_b(TAG_TOME_DISPLAY_NAME)) {
                displayName = stackCmp.func_74779_i(TAG_TOME_DISPLAY_NAME);
            } else {
                stackCmp.func_74778_a(TAG_TOME_DISPLAY_NAME, displayName);
            }
            stack.func_151001_c(EnumChatFormatting.RESET + StatCollector.func_74837_a((String)"akashictome.sudo_name", (Object[])new Object[]{EnumChatFormatting.GREEN + displayName + EnumChatFormatting.RESET}));
        }
        stack.field_77994_a = 1;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)currentStack);
        if (!enchantments.isEmpty()) {
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
            if (currentStack.func_77978_p().func_150297_b("RepairCost", 3)) {
                stack.func_77978_p().func_74768_a("RepairCost", currentStack.func_77978_p().func_74762_e("RepairCost"));
            }
        }
        return stack;
    }

    public static String getModNameForId(String modId) {
        modId = modId.toLowerCase(Locale.ENGLISH);
        return modNames.getOrDefault(modId, modId);
    }

    public static boolean isMorphedTome(ItemStack stack) {
        return MorphingHandler.isAkashicTome(stack) && stack.func_77973_b() != ModItems.tome;
    }

    public static boolean isAkashicTome(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == ModItems.tome) {
            return true;
        }
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_MORPHING);
    }

    static {
        for (Map.Entry modEntry : Loader.instance().getIndexedModList().entrySet()) {
            modNames.put(((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH), ((ModContainer)modEntry.getValue()).getName());
        }
    }
}

