/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.api;

import cpw.mods.fml.common.registry.GameRegistry;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;

@ParametersAreNonnullByDefault
public class ItemDefinition {
    private final String registryName;
    private final int meta;
    private final String nbt;

    public ItemDefinition(String registryName) {
        this(registryName, 0);
    }

    public ItemDefinition(String registryName, @Nonnegative int meta) {
        this(registryName, meta, null);
    }

    public ItemDefinition(String registryName, @Nullable String nbt) {
        this(registryName, 0, nbt);
    }

    public ItemDefinition(String registryName, @Nonnegative int meta, @Nullable String nbt) {
        this.registryName = registryName;
        this.meta = meta;
        this.nbt = nbt;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    @Nonnegative
    public int getMeta() {
        return this.meta;
    }

    @Nullable
    public String getNbt() {
        return this.nbt;
    }

    public ItemStack getAsStack(int stackSize) {
        ItemStack stack = this.getAsStack();
        stack.field_77994_a = stackSize;
        return stack;
    }

    public ItemStack getAsStack() {
        return GameRegistry.makeItemStack((String)this.registryName, (int)this.meta, (int)0, (String)this.nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemDefinition)) return false;
        ItemDefinition other = (ItemDefinition)obj;
        if (!this.registryName.equals(other.registryName)) return false;
        if (this.meta != other.meta && this.meta != Short.MAX_VALUE) {
            if (other.meta != Short.MAX_VALUE) return false;
        }
        if (StringUtils.func_151246_b((String)this.nbt)) return true;
        if (StringUtils.func_151246_b((String)other.nbt)) return true;
        if (!this.nbt.equals(other.nbt)) return false;
        return true;
    }

    public String toString() {
        return String.format("ItemDefinition(registryName=\"%s\", meta=%d, nbt=\"%s\")", this.registryName, this.meta, this.nbt);
    }
}

