/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.trophy;

import glowredman.amazingtrophies.AmazingTrophies;
import glowredman.amazingtrophies.api.AmazingTrophiesAPI;
import glowredman.amazingtrophies.api.TrophyProperties;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.UsernameCache;

public class TileEntityTrophy
extends TileEntity {
    private TrophyProperties props;
    private long time;
    private UUID uuid;
    private String name;

    public TrophyProperties getProperties() {
        return this.props;
    }

    public long getTime() {
        return this.time;
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public String getPlayerName() {
        return this.name;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack(AmazingTrophiesAPI.getTrophyBlock());
        stack.func_77982_d(this.getNBT());
        return stack;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.copyToNBT(nbt);
        return nbt;
    }

    public void copyToNBT(NBTTagCompound nbt) {
        if (this.props != null) {
            nbt.func_74778_a("trophyID", this.props.getID());
        }
        if (this.uuid != null) {
            nbt.func_74778_a("uuid", this.uuid.toString());
        }
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        }
        nbt.func_74772_a("time", this.time);
    }

    public void copyFromNBT(NBTTagCompound nbt) {
        String actualName;
        String id = nbt.func_74764_b("trophyID") ? nbt.func_74779_i("trophyID") : null;
        String name = nbt.func_74779_i("name");
        this.name = name.isEmpty() ? null : name;
        this.props = id == null ? null : AmazingTrophiesAPI.getTrophyProperties(id);
        this.time = nbt.func_74763_f("time");
        String uuid = nbt.func_74779_i("uuid");
        try {
            this.uuid = uuid.isEmpty() ? null : UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            if (this.func_145830_o()) {
                AmazingTrophies.LOGGER.warn(String.format(Locale.ROOT, "Found trophy of type \"%s\" with invalid UUID \"%s\" at x=%d, y=%d, z=%d, dim=%d (%s)!", id, uuid, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g, this.field_145850_b.func_72827_u()), (Throwable)e);
            }
            AmazingTrophies.LOGGER.warn(String.format(Locale.ROOT, "Found trophy of type \"%s\" with invalid UUID \"%s\"!", id, uuid), (Throwable)e);
        }
        if (this.uuid != null && (actualName = UsernameCache.getLastKnownUsername((UUID)this.uuid)) != null) {
            this.name = actualName;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.copyFromNBT(compound);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.copyToNBT(compound);
    }

    public boolean canUpdate() {
        return false;
    }
}

