/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.angelica.dynamiclights;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightSource;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IDynamicLightSource {
    @Shadow
    public World field_70170_p;
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    @Shadow
    public int field_70176_ah;
    @Shadow
    public int field_70164_aj;
    @Shadow
    public boolean field_70128_L;
    @Unique
    protected int angelica$luminance = 0;
    @Unique
    private int angelica$lastLuminance = 0;
    @Unique
    private static long angelica$lastUpdate = 0L;
    @Unique
    private double angelica$prevX;
    @Unique
    private double angelica$prevY;
    @Unique
    private double angelica$prevZ;
    @Unique
    private LongOpenHashSet angelica$trackedLitChunkPos = new LongOpenHashSet();

    @Shadow
    public abstract float func_70047_e();

    @Override
    public double angelica$getDynamicLightX() {
        return this.field_70165_t;
    }

    @Override
    public double angelica$getDynamicLightY() {
        return this.field_70163_u + (double)this.func_70047_e();
    }

    @Override
    public double angelica$getDynamicLightZ() {
        return this.field_70161_v;
    }

    @Override
    public void angelica$resetDynamicLight() {
        this.angelica$lastLuminance = 0;
    }

    @Inject(method={"onEntityUpdate"}, at={@At(value="TAIL")})
    public void angelica$onUpdate(CallbackInfo ci) {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            if (this.field_70128_L) {
                this.angelica$setDynamicLightEnabled(false);
            } else {
                this.angelica$dynamicLightTick();
                DynamicLights.updateTracking(this);
            }
        }
    }

    @Override
    public void angelica$dynamicLightTick() {
        this.angelica$luminance = DynamicLights.getLuminanceFromEntity((Entity)this);
    }

    @Override
    public int angelica$getLuminance() {
        return this.angelica$luminance;
    }

    @Override
    public boolean angelica$updateDynamicLight(@NotNull SodiumWorldRenderer renderer) {
        double deltaX = this.field_70165_t - this.angelica$prevX;
        double deltaY = this.field_70163_u - this.angelica$prevY;
        double deltaZ = this.field_70161_v - this.angelica$prevZ;
        int luminance = this.angelica$getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.angelica$lastLuminance) {
            this.angelica$prevX = this.field_70165_t;
            this.angelica$prevY = this.field_70163_u;
            this.angelica$prevZ = this.field_70161_v;
            this.angelica$lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                BlockPos chunkPos = new BlockPos(this.field_70176_ah, MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())) >> 4, this.field_70164_aj);
                DynamicLights.scheduleChunkRebuild(renderer, (IBlockPos)chunkPos);
                DynamicLights.updateTrackedChunks((IBlockPos)chunkPos, this.angelica$trackedLitChunkPos, newPos);
                ForgeDirection directionX = (MathHelper.func_76128_c((double)this.field_70165_t) & 0xF) >= 8 ? ForgeDirection.EAST : ForgeDirection.WEST;
                ForgeDirection directionY = (MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())) & 0xF) >= 8 ? ForgeDirection.UP : ForgeDirection.DOWN;
                ForgeDirection directionZ = (MathHelper.func_76128_c((double)this.field_70161_v) & 0xF) >= 8 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos = chunkPos.offset(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos = chunkPos.offset(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos = chunkPos.offset(directionX.getOpposite());
                    } else {
                        chunkPos = chunkPos.offset(directionZ.getOpposite());
                        chunkPos = chunkPos.offset(directionY);
                    }
                    DynamicLights.scheduleChunkRebuild(renderer, (IBlockPos)chunkPos);
                    DynamicLights.updateTrackedChunks((IBlockPos)chunkPos, this.angelica$trackedLitChunkPos, newPos);
                }
            }
            this.angelica$scheduleTrackedChunksRebuild(renderer);
            this.angelica$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void angelica$scheduleTrackedChunksRebuild(@NotNull SodiumWorldRenderer renderer) {
        LongIterator longIterator = this.angelica$trackedLitChunkPos.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            DynamicLights.scheduleChunkRebuild(renderer, pos);
        }
    }
}

