/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.org.anarres.cpp;

import com.gtnewhorizons.angelica.shadow.javax.annotation.Nonnull;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.InputLexerSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class FileLexerSource
extends InputLexerSource {
    private final String path;
    private final File file;

    public FileLexerSource(@Nonnull File file, @Nonnull Charset charset, @Nonnull String path) throws IOException {
        super(new FileInputStream(file), charset);
        this.file = file;
        this.path = path;
    }

    public FileLexerSource(@Nonnull File file, @Nonnull String path) throws IOException {
        this(file, Charset.defaultCharset(), path);
    }

    public FileLexerSource(@Nonnull File file, @Nonnull Charset charset) throws IOException {
        this(file, charset, file.getPath());
    }

    @Deprecated
    public FileLexerSource(@Nonnull File file) throws IOException {
        this(file, Charset.defaultCharset());
    }

    public FileLexerSource(@Nonnull String path, @Nonnull Charset charset) throws IOException {
        this(new File(path), charset, path);
    }

    @Deprecated
    public FileLexerSource(@Nonnull String path) throws IOException {
        this(path, Charset.defaultCharset());
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.getPath();
    }

    public String toString() {
        return "file " + this.getPath();
    }
}

