/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.ResourceLocationWithSource;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;

public class ResourceList {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.TEXTURE_PACK);
    private static ResourceList instance;
    private static final Map<IResourcePack, Integer> resourcePackOrder;
    private final IResourcePack resourcePack;
    private final Set<ResourceLocationWithSource> allResources = new TreeSet<ResourceLocationWithSource>(new ResourceLocationWithSource.Comparator1());

    public static ResourceList getInstance() {
        if (instance == null) {
            List<IResourcePack> resourcePacks = TexturePackAPI.getResourcePacks(null);
            int order = resourcePacks.size();
            resourcePackOrder.clear();
            for (IResourcePack resourcePack : resourcePacks) {
                resourcePackOrder.put(resourcePack, order);
                --order;
            }
            instance = new ResourceList();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static int getResourcePackOrder(IResourcePack resourcePack) {
        Integer i = resourcePackOrder.get(resourcePack);
        return i == null ? Integer.MAX_VALUE : i;
    }

    private ResourceList() {
        this.resourcePack = null;
        for (IResourcePack resourcePack : TexturePackAPI.getResourcePacks(null)) {
            ResourceList sublist;
            if (resourcePack instanceof FileResourcePack) {
                sublist = new ResourceList((FileResourcePack)resourcePack);
            } else if (resourcePack instanceof DefaultResourcePack) {
                sublist = new ResourceList((DefaultResourcePack)resourcePack);
            } else {
                if (!(resourcePack instanceof AbstractResourcePack)) continue;
                sublist = new ResourceList((AbstractResourcePack)resourcePack);
            }
            this.allResources.removeAll(sublist.allResources);
            this.allResources.addAll(sublist.allResources);
        }
        logger.fine("new %s", this);
        if (logger.isLoggable(Level.FINEST)) {
            for (ResourceLocationWithSource resource : this.allResources) {
                logger.finest("%s -> %s", new Object[]{resource, resource.getSource().func_130077_b()});
            }
        }
    }

    private ResourceList(FileResourcePack resourcePack) {
        this.resourcePack = resourcePack;
        try {
            this.scanZipFile(resourcePack.func_110599_c());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), new Object[0]);
        }
        logger.fine("new %s", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceList(DefaultResourcePack resourcePack) {
        Map map;
        this.resourcePack = resourcePack;
        String version = "1.7.10";
        File jar = MCPatcherUtils.getMinecraftPath("versions", version, version + ".jar");
        if (jar.isFile()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(jar);
                this.scanZipFile(zipFile);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(zipFile);
                    throw throwable;
                }
                MCPatcherUtils.close(zipFile);
            }
            MCPatcherUtils.close(zipFile);
        }
        if ((map = resourcePack.field_152781_b) != null) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                File file = (File)entry.getValue();
                ResourceLocation resource = new ResourceLocation(key);
                this.addResource(resource, file.isFile(), file.isDirectory());
            }
        }
        if (!this.allResources.isEmpty()) {
            logger.fine("new %s", this);
        }
    }

    private ResourceList(AbstractResourcePack resourcePack) {
        this.resourcePack = resourcePack;
        File directory = resourcePack.field_110597_b;
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        HashSet<String> allFiles = new HashSet<String>();
        ResourceList.listAllFiles(directory, "", allFiles);
        for (String path : allFiles) {
            ResourceLocation resource = TexturePackAPI.parsePath(path);
            if (resource == null) continue;
            File file = new File(directory, path);
            this.addResource(resource, file.isFile(), file.isDirectory());
        }
        logger.fine("new %s", this);
    }

    private void scanZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String path = zipEntry.getName();
            ResourceLocation resource = TexturePackAPI.parsePath(path);
            if (resource == null) continue;
            this.addResource(resource, !zipEntry.isDirectory(), zipEntry.isDirectory());
        }
    }

    private static void listAllFiles(File base, String subdir, Set<String> files) {
        File[] entries = new File(base, subdir).listFiles();
        if (entries == null) {
            return;
        }
        for (File file : entries) {
            String newPath = subdir + file.getName();
            if (!files.add(newPath) || !file.isDirectory()) continue;
            ResourceList.listAllFiles(base, subdir + file.getName() + '/', files);
        }
    }

    private void addResource(ResourceLocation resource, boolean isFile, boolean isDirectory) {
        if (isFile) {
            this.allResources.add(new ResourceLocationWithSource(this.resourcePack, resource));
        } else if (isDirectory) {
            if (!resource.func_110623_a().endsWith("/")) {
                resource = new ResourceLocation(resource.func_110624_b(), resource.func_110623_a() + '/');
            }
            this.allResources.add(new ResourceLocationWithSource(this.resourcePack, resource));
        }
    }

    public List<ResourceLocation> listResources(String directory, String suffix, boolean sortByFilename) {
        return this.listResources(directory, suffix, true, false, sortByFilename);
    }

    public List<ResourceLocation> listResources(String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        return this.listResources(null, directory, suffix, recursive, directories, sortByFilename);
    }

    public List<ResourceLocation> listResources(String namespace, String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        if (suffix == null) {
            suffix = "";
        }
        if (MCPatcherUtils.isNullOrEmpty(directory)) {
            directory = "";
        } else if (!directory.endsWith("/")) {
            directory = directory + '/';
        }
        TreeSet<ResourceLocationWithSource> tmpList = new TreeSet<ResourceLocationWithSource>(new ResourceLocationWithSource.Comparator1(true, sortByFilename ? suffix : null));
        boolean allNamespaces = MCPatcherUtils.isNullOrEmpty(namespace);
        for (ResourceLocationWithSource resource : this.allResources) {
            String subpath;
            String path;
            if (directories != resource.isDirectory() || !allNamespaces && !namespace.equals(resource.func_110624_b()) || !(path = resource.func_110623_a()).endsWith(suffix) || !path.startsWith(directory) || !recursive && (subpath = path.substring(directory.length())).contains("/")) continue;
            tmpList.add(resource);
        }
        return new ArrayList<ResourceLocation>(tmpList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourceList: ");
        if (this.resourcePack == null) {
            sb.append("(combined) ");
        } else {
            sb.append(this.resourcePack.func_130077_b()).append(' ');
        }
        int fileCount = 0;
        int directoryCount = 0;
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocationWithSource resource : this.allResources) {
            if (resource.isDirectory()) {
                ++directoryCount;
            } else {
                ++fileCount;
            }
            namespaces.add(resource.func_110624_b());
        }
        sb.append(fileCount).append(" files, ");
        sb.append(directoryCount).append(" directories in ");
        sb.append(namespaces.size()).append(" namespaces");
        return sb.toString();
    }

    static {
        resourcePackOrder = new WeakHashMap<IResourcePack, Integer>();
    }
}

