/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import java.net.URI;
import java.net.URISyntaxException;
import net.coderbot.iris.Iris;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum PBRType {
    NORMAL("_n", 0x7F7FFFFF),
    SPECULAR("_s", 0);

    private static final PBRType[] VALUES;
    private final String suffix;
    private final int defaultValue;

    private PBRType(String suffix, int defaultValue) {
        this.suffix = suffix;
        this.defaultValue = defaultValue;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public ResourceLocation appendToFileLocation(ResourceLocation location) {
        String domain = location.func_110624_b();
        String path = location.func_110623_a();
        try {
            URI uri = new URI(null, null, path, null);
            String cleanPath = uri.getPath();
            int extensionIndex = PBRType.safeIndexOfExtension(cleanPath);
            String newPath = extensionIndex != -1 ? cleanPath.substring(0, extensionIndex) + this.suffix + cleanPath.substring(extensionIndex) : cleanPath + this.suffix;
            URI newUri = new URI(null, null, newPath, null);
            newPath = newUri.getPath();
            return new ResourceLocation(domain, newPath);
        }
        catch (URISyntaxException e) {
            Iris.logger.error("Failed to append PBR suffix to resource location for " + path, e);
            return location;
        }
    }

    @Nullable
    public static PBRType fromFileLocation(String location) {
        for (PBRType type : VALUES) {
            if (!location.endsWith(type.getSuffix())) continue;
            return type;
        }
        return null;
    }

    private static int safeIndexOfExtension(String input) {
        if (input == null) {
            return -1;
        }
        int lastSlash = Math.max(input.lastIndexOf(47), input.lastIndexOf(92));
        int nameStart = lastSlash + 1;
        int lastDot = input.lastIndexOf(46);
        if (lastDot == -1 || lastDot <= nameStart || lastDot == input.length() - 1) {
            return -1;
        }
        return lastDot;
    }

    static {
        VALUES = PBRType.values();
    }
}

