/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseTileBlock;
import appeng.block.misc.BlockLightDetector;
import appeng.block.misc.BlockSkyCompass;
import appeng.block.networking.BlockWireless;
import appeng.client.render.ItemRenderer;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public class AEBaseItemBlock
extends ItemBlock {
    private final AEBaseBlock blockType;

    public AEBaseItemBlock(Block id) {
        super(id);
        this.blockType = (AEBaseBlock)id;
        this.field_77787_bX = this.blockType.hasSubtypes;
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)ItemRenderer.INSTANCE);
        }
    }

    public int func_77647_b(int dmg) {
        if (this.field_77787_bX) {
            return dmg;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean advancedTooltips) {
        this.addCheckedInformation(itemStack, player, toolTip, advancedTooltips);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean advancedToolTips) {
        this.blockType.addInformation(itemStack, player, toolTip, advancedToolTips);
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public String func_77667_c(ItemStack is) {
        return this.blockType.getUnlocalizedName(is);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        ForgeDirection up = ForgeDirection.UNKNOWN;
        ForgeDirection forward = ForgeDirection.UNKNOWN;
        if (this.blockType instanceof AEBaseTileBlock) {
            if (this.blockType instanceof BlockLightDetector) {
                up = ForgeDirection.getOrientation((int)side);
                forward = up == ForgeDirection.UP || up == ForgeDirection.DOWN ? ForgeDirection.SOUTH : ForgeDirection.UP;
            } else if (this.blockType instanceof BlockWireless || this.blockType instanceof BlockSkyCompass) {
                forward = ForgeDirection.getOrientation((int)side);
                up = forward == ForgeDirection.UP || forward == ForgeDirection.DOWN ? ForgeDirection.SOUTH : ForgeDirection.UP;
            } else {
                up = ForgeDirection.UP;
                byte rotation = (byte)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3);
                switch (rotation) {
                    default: {
                        ForgeDirection forgeDirection = ForgeDirection.SOUTH;
                        break;
                    }
                    case 1: {
                        ForgeDirection forgeDirection = ForgeDirection.WEST;
                        break;
                    }
                    case 2: {
                        ForgeDirection forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    case 3: {
                        ForgeDirection forgeDirection = forward = ForgeDirection.EAST;
                    }
                }
                if (player.field_70125_A > 65.0f) {
                    up = forward.getOpposite();
                    forward = ForgeDirection.UP;
                } else if (player.field_70125_A < -65.0f) {
                    up = forward.getOpposite();
                    forward = ForgeDirection.DOWN;
                }
            }
        }
        IOrientable ori = null;
        if (this.blockType instanceof IOrientableBlock) {
            ori = this.blockType.getOrientable((IBlockAccess)w, x, y, z);
            up = ForgeDirection.getOrientation((int)side);
            forward = ForgeDirection.SOUTH;
            if (up.offsetY == 0) {
                forward = ForgeDirection.UP;
            }
        }
        if (!this.blockType.isValidOrientation(w, x, y, z, forward, up)) {
            return false;
        }
        if (super.placeBlockAt(stack, player, w, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            if (this.blockType instanceof AEBaseTileBlock && !(this.blockType instanceof BlockLightDetector)) {
                Object tile = ((AEBaseTileBlock)this.blockType).getTileEntity((IBlockAccess)w, x, y, z);
                ori = tile;
                if (tile == null) {
                    return true;
                }
                if (ori.canBeRotated() && !this.blockType.hasCustomRotation() && (ori.getForward() == null || ori.getUp() == null || ((AEBaseTile)tile).getForward() == ForgeDirection.UNKNOWN || ori.getUp() == ForgeDirection.UNKNOWN)) {
                    ori.setOrientation(forward, up);
                }
                if (tile instanceof IGridProxyable) {
                    ((IGridProxyable)tile).getProxy().setOwner(player);
                }
                ((AEBaseTile)tile).onPlacement(stack, player, side);
            } else if (this.blockType instanceof IOrientableBlock) {
                ori.setOrientation(forward, up);
            }
            return true;
        }
        return false;
    }
}

