/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.AdvancedBlockingMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.GuiUpgradeable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiSimpleImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.GuiToggleButton;
import appeng.container.implementations.ContainerInterface;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.IInterfaceHost;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiInterface
extends GuiUpgradeable {
    private GuiTabButton priority;
    private GuiImgButton BlockMode;
    private GuiImgButton SmartBlockMode;
    private GuiImgButton fuzzyMode;
    private GuiToggleButton interfaceMode;
    private GuiImgButton insertionMode;
    private GuiSimpleImgButton doublePatterns;
    private GuiToggleButton patternOptimization;
    private GuiImgButton advancedBlockingMode;
    private GuiImgButton lockCraftingMode;

    public GuiInterface(InventoryPlayer inventoryPlayer, IInterfaceHost te) {
        super(new ContainerInterface(inventoryPlayer, te));
        this.field_147000_g = 211;
    }

    @Override
    protected void addButtons() {
        this.priority = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, 66, GuiText.Priority.getLocal(), field_146296_j);
        this.field_146292_n.add(this.priority);
        int offset = 8;
        this.BlockMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + offset, Settings.BLOCK, YesNo.NO);
        this.field_146292_n.add(this.BlockMode);
        this.SmartBlockMode = new GuiImgButton(this.field_147003_i - 36, this.field_147009_r + offset, Settings.SMART_BLOCK, YesNo.NO);
        this.field_146292_n.add(this.SmartBlockMode);
        this.interfaceMode = new GuiToggleButton(this.field_147003_i - 18, this.field_147009_r + (offset += 18), 84, 85, GuiText.InterfaceTerminal.getLocal(), GuiText.InterfaceTerminalHint.getLocal());
        this.field_146292_n.add(this.interfaceMode);
        this.insertionMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + (offset += 18), Settings.INSERTION_MODE, InsertionMode.DEFAULT);
        this.field_146292_n.add(this.insertionMode);
        this.doublePatterns = new GuiSimpleImgButton(this.field_147003_i - 18, this.field_147009_r + (offset += 18), 71, "");
        this.doublePatterns.field_146124_l = false;
        this.field_146292_n.add(this.doublePatterns);
        this.patternOptimization = new GuiToggleButton(this.field_147003_i - 18, this.field_147009_r + (offset += 18), 178, 194, GuiText.PatternOptimization.getLocal(), GuiText.PatternOptimizationHint.getLocal());
        this.field_146292_n.add(this.patternOptimization);
        this.advancedBlockingMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + (offset += 18), Settings.ADVANCED_BLOCKING_MODE, AdvancedBlockingMode.DEFAULT);
        this.advancedBlockingMode.field_146125_m = this.bc.getInstalledUpgrades(Upgrades.ADVANCED_BLOCKING) > 0;
        this.field_146292_n.add(this.advancedBlockingMode);
        this.lockCraftingMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + (offset += 18), Settings.LOCK_CRAFTING_MODE, LockCraftingMode.NONE);
        this.lockCraftingMode.field_146125_m = this.bc.getInstalledUpgrades(Upgrades.LOCK_CRAFTING) > 0;
        this.field_146292_n.add(this.lockCraftingMode);
        this.fuzzyMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + (offset += 18), Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.fuzzyMode.field_146125_m = this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0;
        this.field_146292_n.add(this.fuzzyMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.BlockMode != null) {
            this.BlockMode.set(((ContainerInterface)this.cvb).getBlockingMode());
        }
        if (this.SmartBlockMode != null) {
            this.SmartBlockMode.set(((ContainerInterface)this.cvb).getSmartBlockingMode());
        }
        if (this.interfaceMode != null) {
            this.interfaceMode.setState(((ContainerInterface)this.cvb).getInterfaceTerminalMode() == YesNo.YES);
        }
        if (this.insertionMode != null) {
            this.insertionMode.set(((ContainerInterface)this.cvb).getInsertionMode());
        }
        if (this.doublePatterns != null) {
            this.doublePatterns.field_146124_l = ((ContainerInterface)this.cvb).isAllowedToMultiplyPatterns;
            if (this.doublePatterns.field_146124_l) {
                this.doublePatterns.setTooltip(ButtonToolTips.DoublePatterns.getLocal() + "\n" + ButtonToolTips.DoublePatternsHint.getLocal());
            } else {
                this.doublePatterns.setTooltip(ButtonToolTips.DoublePatterns.getLocal() + "\n" + ButtonToolTips.OptimizePatternsNoReq.getLocal());
            }
        }
        if (this.patternOptimization != null) {
            this.patternOptimization.setState(((ContainerInterface)this.cvb).getPatternOptimization() == YesNo.YES);
        }
        if (this.advancedBlockingMode != null) {
            this.advancedBlockingMode.set(((ContainerInterface)this.cvb).getAdvancedBlockingMode());
        }
        if (this.lockCraftingMode != null) {
            this.lockCraftingMode.set(((ContainerInterface)this.cvb).getLockCraftingMode());
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(((ContainerInterface)this.cvb).getFuzzyMode());
        }
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.Interface.getLocal()), 8, 6, GuiColors.InterfaceTitle.getColor());
    }

    @Override
    protected String getBackground() {
        String string;
        switch (((ContainerInterface)this.cvb).getPatternCapacityCardsInstalled()) {
            case -1: {
                string = "guis/interfacenonenoconfig.png";
                break;
            }
            case 1: {
                string = "guis/interface2.png";
                break;
            }
            case 2: {
                string = "guis/interface3.png";
                break;
            }
            case 3: {
                string = "guis/interface4.png";
                break;
            }
            default: {
                string = "guis/interface.png";
            }
        }
        return string;
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.priority) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(GuiBridge.GUI_PRIORITY));
        }
        if (btn == this.interfaceMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(Settings.INTERFACE_TERMINAL, backwards));
        }
        if (btn == this.BlockMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.BlockMode.getSetting(), backwards));
        }
        if (btn == this.SmartBlockMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.SmartBlockMode.getSetting(), backwards));
        }
        if (btn == this.insertionMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.insertionMode.getSetting(), backwards));
        }
        if (btn == this.doublePatterns) {
            try {
                int val;
                int n = val = Keyboard.isKeyDown((int)42) ? 1 : 0;
                if (backwards) {
                    val |= 2;
                }
                NetworkHandler.instance.sendToServer(new PacketValueConfig("Interface.DoublePatterns", String.valueOf(val)));
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
        if (btn == this.patternOptimization) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(Settings.PATTERN_OPTIMIZATION, backwards));
        }
        if (btn == this.advancedBlockingMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.advancedBlockingMode.getSetting(), backwards));
        }
        if (btn == this.lockCraftingMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.lockCraftingMode.getSetting(), backwards));
        }
        if (btn == this.fuzzyMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.fuzzyMode.getSetting(), backwards));
        }
    }

    @Override
    protected void handleButtonVisibility() {
        super.handleButtonVisibility();
        if (this.advancedBlockingMode != null) {
            this.advancedBlockingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.ADVANCED_BLOCKING) > 0);
        }
        if (this.lockCraftingMode != null) {
            this.lockCraftingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.LOCK_CRAFTING) > 0);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
        }
    }
}

