/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.config.LockCraftingMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.localization.WailaText;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.integration.modules.waila.BaseWailaDataProvider;
import appeng.util.item.AEItemStack;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class InterfaceDataProvider
extends BaseWailaDataProvider {
    private static final String NBT_LOCK_REASON = "craftingLockReason";
    private static final String NBT_LOCK_STACKS = "craftingLockStacks";

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() instanceof IInterfaceHost && accessor.getNBTData().func_74764_b(NBT_LOCK_REASON)) {
            String lockReasonText = accessor.getNBTData().func_74779_i(NBT_LOCK_REASON);
            LockCraftingMode lockReason = LockCraftingMode.valueOf(lockReasonText);
            switch (lockReason) {
                case LOCK_UNTIL_PULSE: {
                    currentToolTip.add(WailaText.CraftingLockedUntilPulse.getLocal());
                    break;
                }
                case LOCK_WHILE_HIGH: {
                    currentToolTip.add(WailaText.CraftingLockedByRedstoneSignal.getLocal());
                    break;
                }
                case LOCK_WHILE_LOW: {
                    currentToolTip.add(WailaText.CraftingLockedByLackOfRedstoneSignal.getLocal());
                    break;
                }
                case LOCK_UNTIL_RESULT: {
                    currentToolTip.add(WailaText.CraftingLockedUntilResult.getLocal());
                    if (accessor.getNBTData().func_74764_b(NBT_LOCK_STACKS)) {
                        NBTTagList stackList = accessor.getNBTData().func_150295_c(NBT_LOCK_STACKS, 10);
                        for (int index = 0; index < stackList.func_74745_c(); ++index) {
                            NBTTagCompound stackTag = stackList.func_150305_b(index);
                            AEItemStack stack = (AEItemStack)AEItemStack.loadItemStackFromNBT(stackTag);
                            if (stack != null) {
                                currentToolTip.add("> " + stack.getStackSize() + " " + stack.getDisplayName());
                                continue;
                            }
                            currentToolTip.add("ERROR");
                        }
                        break;
                    }
                    currentToolTip.add("ERROR");
                }
            }
        }
        return currentToolTip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof IInterfaceHost) {
            List<IAEItemStack> unlockStacks;
            DualityInterface interfaceDuality = ((IInterfaceHost)te).getInterfaceDuality();
            tag.func_74778_a(NBT_LOCK_REASON, interfaceDuality.getCraftingLockedReason().name());
            LockCraftingMode lock = interfaceDuality.getCraftingLockedReason();
            if (lock == LockCraftingMode.LOCK_UNTIL_RESULT && (unlockStacks = interfaceDuality.getUnlockStacks()) != null && !unlockStacks.isEmpty()) {
                NBTTagList stackList = new NBTTagList();
                for (IAEItemStack stack : unlockStacks) {
                    NBTTagCompound stackTag = new NBTTagCompound();
                    stack.writeToNBT(stackTag);
                    stackList.func_74742_a((NBTBase)stackTag);
                }
                tag.func_74782_a(NBT_LOCK_STACKS, (NBTBase)stackList);
            }
        }
        return tag;
    }
}

