/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridConnectionVisitor;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.me.Grid;
import appeng.me.GridConnection;
import appeng.me.GridPropagator;
import appeng.me.GridSplitDetector;
import appeng.me.GridStorage;
import appeng.me.cache.CraftingGridCache;
import appeng.me.pathfinding.IPathItem;
import appeng.tile.networking.TileController;
import appeng.util.IWorldCallable;
import appeng.util.ReadOnlyCollection;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GridNode
implements IGridNode,
IPathItem {
    private static final MENetworkChannelsChanged EVENT = new MENetworkChannelsChanged();
    private static final int[] CHANNEL_COUNT = new int[]{0, 8, 32, Integer.MAX_VALUE};
    private final List<GridConnection> connections = new LinkedList<GridConnection>();
    private final IGridBlock gridProxy;
    private double previousDraw = 0.0;
    private long lastSecurityKey = -1L;
    private int playerID = -1;
    private GridStorage myStorage = null;
    private Grid myGrid;
    private Object visitorIterationNumber = null;
    private int compressedData = 0;
    int usedChannels = 0;
    private int lastUsedChannels = 0;
    @Nullable
    private GridNode highestSimilarAncestor = null;
    private int subtreeMaxChannels;
    private boolean subtreeAllowsCompressedChannels;

    public GridNode(IGridBlock what) {
        this.gridProxy = what;
    }

    IGridBlock getGridProxy() {
        return this.gridProxy;
    }

    Grid getMyGrid() {
        return this.myGrid;
    }

    public int usedChannels() {
        return this.lastUsedChannels;
    }

    Class<? extends IGridHost> getMachineClass() {
        return this.getMachine().getClass();
    }

    void addConnection(IGridConnection gridConnection) {
        this.connections.add((GridConnection)gridConnection);
        if (gridConnection.hasDirection()) {
            this.gridProxy.onGridNotification(GridNotification.ConnectionsChanged);
        }
    }

    void removeConnection(IGridConnection gridConnection) {
        this.connections.remove(gridConnection);
        if (gridConnection.hasDirection()) {
            this.gridProxy.onGridNotification(GridNotification.ConnectionsChanged);
        }
    }

    boolean hasConnection(IGridNode otherSide) {
        for (IGridConnection iGridConnection : this.connections) {
            if (iGridConnection.a() != otherSide && iGridConnection.b() != otherSide) continue;
            return true;
        }
        return false;
    }

    void validateGrid() {
        GridSplitDetector gsd = new GridSplitDetector(this.getInternalGrid().getPivot());
        this.beginVisit(gsd);
        if (!gsd.isPivotFound()) {
            GridPropagator gp = new GridPropagator(new Grid(this));
            this.beginVisit(gp);
        }
    }

    public Grid getInternalGrid() {
        if (this.myGrid == null) {
            this.myGrid = new Grid(this);
        }
        return this.myGrid;
    }

    @Override
    public void beginVisit(IGridVisitor g) {
        Object tracker = new Object();
        CraftingGridCache.pauseRebuilds();
        LinkedList<GridNode> nextRun = new LinkedList<GridNode>();
        nextRun.add(this);
        this.visitorIterationNumber = tracker;
        if (g instanceof IGridConnectionVisitor) {
            IGridConnectionVisitor gcv = (IGridConnectionVisitor)g;
            LinkedList<IGridConnection> nextConn = new LinkedList<IGridConnection>();
            while (!nextRun.isEmpty()) {
                while (!nextConn.isEmpty()) {
                    gcv.visitConnection((IGridConnection)nextConn.poll());
                }
                LinkedList<GridNode> thisRun = nextRun;
                nextRun = new LinkedList();
                for (GridNode n : thisRun) {
                    n.visitorConnection(tracker, g, nextRun, nextConn);
                }
            }
        } else {
            while (!nextRun.isEmpty()) {
                LinkedList<GridNode> thisRun = nextRun;
                nextRun = new LinkedList();
                for (GridNode n : thisRun) {
                    n.visitorNode(tracker, g, nextRun);
                }
            }
        }
        CraftingGridCache.unpauseRebuilds();
    }

    @Override
    public void updateState() {
        this.compressedData = this.getCompressedChannelsIndex();
        this.compressedData |= this.gridProxy.getGridColor().ordinal() << 3;
        for (ForgeDirection dir : this.gridProxy.getConnectableSides()) {
            this.compressedData |= 1 << dir.ordinal() + 8;
        }
        this.FindConnections();
        this.getInternalGrid();
    }

    private int getCompressedChannelsIndex() {
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.Channels)) {
            return 3;
        }
        if (this.hasFlag(GridFlags.CANNOT_CARRY)) {
            return 0;
        }
        if (this.hasFlag(GridFlags.DENSE_CAPACITY)) {
            return 2;
        }
        return 1;
    }

    @Override
    public IGridHost getMachine() {
        return this.gridProxy.getMachine();
    }

    @Override
    public IGrid getGrid() {
        return this.myGrid;
    }

    void setGrid(Grid grid) {
        if (this.myGrid == grid) {
            return;
        }
        if (this.myGrid != null) {
            this.myGrid.remove(this);
            if (this.myGrid.isEmpty()) {
                this.myGrid.saveState();
                for (IGridCache c : grid.getCaches().values()) {
                    c.onJoin(this.myGrid.getMyStorage());
                }
            }
        }
        this.myGrid = grid;
        this.myGrid.add(this);
    }

    @Override
    public void destroy() {
        while (!this.connections.isEmpty()) {
            if (this.connections.size() == 1) {
                this.setGridStorage(null);
            }
            IGridConnection c = this.connections.listIterator().next();
            GridNode otherSide = (GridNode)c.getOtherSide(this);
            otherSide.getInternalGrid().setPivot(otherSide);
            c.destroy();
        }
        if (this.myGrid != null) {
            this.myGrid.remove(this);
        }
    }

    @Override
    public World getWorld() {
        return this.gridProxy.getLocation().getWorld();
    }

    @Override
    public EnumSet<ForgeDirection> getConnectedSides() {
        EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
        for (IGridConnection iGridConnection : this.connections) {
            set.add(iGridConnection.getDirection(this));
        }
        return set;
    }

    @Override
    public IReadOnlyCollection<IGridConnection> getConnections() {
        return new ReadOnlyCollection<IGridConnection>((Collection<IGridConnection>)this.connections);
    }

    public boolean hasNoConnections() {
        return this.connections.isEmpty();
    }

    @Override
    public IGridBlock getGridBlock() {
        return this.gridProxy;
    }

    @Override
    public boolean isActive() {
        IGrid g = this.getGrid();
        if (g != null) {
            IPathingGrid pg = (IPathingGrid)g.getCache(IPathingGrid.class);
            IEnergyGrid eg = (IEnergyGrid)g.getCache(IEnergyGrid.class);
            return this.meetsChannelRequirements() && eg.isNetworkPowered() && !pg.isNetworkBooting();
        }
        return false;
    }

    @Override
    public void loadFromNBT(String name, NBTTagCompound nodeData) {
        if (this.myGrid != null) {
            throw new IllegalStateException("Loading data after part of a grid, this is invalid.");
        }
        NBTTagCompound node = nodeData.func_74775_l(name);
        this.playerID = node.func_74762_e("p");
        this.setLastSecurityKey(node.func_74763_f("k"));
        long storageID = node.func_74763_f("g");
        GridStorage gridStorage = WorldData.instance().storageData().getGridStorage(storageID);
        this.setGridStorage(gridStorage);
    }

    @Override
    public void saveToNBT(String name, NBTTagCompound nodeData) {
        if (this.myStorage != null) {
            NBTTagCompound node = new NBTTagCompound();
            node.func_74768_a("p", this.playerID);
            node.func_74772_a("k", this.getLastSecurityKey());
            node.func_74772_a("g", this.myStorage.getID());
            nodeData.func_74782_a(name, (NBTBase)node);
        } else {
            nodeData.func_82580_o(name);
        }
    }

    @Override
    public boolean meetsChannelRequirements() {
        return !this.hasFlag(GridFlags.REQUIRE_CHANNEL) || this.getUsedChannels() > 0;
    }

    @Override
    public boolean hasFlag(GridFlags flag) {
        return this.gridProxy.hasFlag(flag);
    }

    @Override
    public int getPlayerID() {
        return this.playerID;
    }

    @Override
    public void setPlayerID(int playerID) {
        if (playerID >= 0) {
            this.playerID = playerID;
        }
    }

    public int getUsedChannels() {
        return this.lastUsedChannels;
    }

    private void FindConnections() {
        if (!this.gridProxy.isWorldAccessible()) {
            return;
        }
        EnumSet<ForgeDirection> newSecurityConnections = EnumSet.noneOf(ForgeDirection.class);
        DimensionalCoord dc = this.gridProxy.getLocation();
        for (ForgeDirection f : ForgeDirection.VALID_DIRECTIONS) {
            GridNode node;
            IGridHost te = this.findGridHost(dc.getWorld(), dc.x + f.offsetX, dc.y + f.offsetY, dc.z + f.offsetZ);
            if (te == null || (node = (GridNode)te.getGridNode(f.getOpposite())) == null) continue;
            boolean isValidConnection = this.canConnect(node, f) && node.canConnect(this, f.getOpposite());
            IGridConnection con = null;
            for (IGridConnection c : this.getConnections()) {
                if (c.getDirection(this) != f) continue;
                con = c;
                break;
            }
            if (con != null) {
                IGridNode os = con.getOtherSide(this);
                if (os == node) {
                    if (isValidConnection) continue;
                    con.destroy();
                    continue;
                }
                con.destroy();
                continue;
            }
            if (!isValidConnection) continue;
            if (node.getLastSecurityKey() != -1L) {
                newSecurityConnections.add(f);
                continue;
            }
            try {
                new GridConnection(node, this, f.getOpposite());
            }
            catch (FailedConnection e) {
                TickHandler.INSTANCE.addCallable(node.getWorld(), new MachineSecurityBreak(this));
                return;
            }
        }
        for (ForgeDirection f : newSecurityConnections) {
            GridNode node;
            IGridHost te = this.findGridHost(dc.getWorld(), dc.x + f.offsetX, dc.y + f.offsetY, dc.z + f.offsetZ);
            if (te == null || (node = (GridNode)te.getGridNode(f.getOpposite())) == null) continue;
            try {
                new GridConnection(node, this, f.getOpposite());
            }
            catch (FailedConnection e) {
                TickHandler.INSTANCE.addCallable(node.getWorld(), new MachineSecurityBreak(this));
                return;
            }
        }
    }

    private IGridHost findGridHost(World world, int x, int y, int z) {
        TileEntity te;
        if (world.func_72899_e(x, y, z) && (te = world.func_147438_o(x, y, z)) instanceof IGridHost) {
            return (IGridHost)te;
        }
        return null;
    }

    private boolean canConnect(GridNode from, ForgeDirection dir) {
        if (!this.isValidDirection(dir)) {
            return false;
        }
        return from.getColor().matches(this.getColor());
    }

    private boolean isValidDirection(ForgeDirection dir) {
        return (this.compressedData & 1 << 8 + dir.ordinal()) > 0;
    }

    private AEColor getColor() {
        return AEColor.values()[this.compressedData >> 3 & 0x1F];
    }

    private void visitorConnection(Object tracker, IGridVisitor g, Deque<GridNode> nextRun, Deque<IGridConnection> nextConnections) {
        if (g.visitNode(this)) {
            for (IGridConnection gc : this.getConnections()) {
                GridNode gn = (GridNode)gc.getOtherSide(this);
                GridConnection gcc = (GridConnection)gc;
                if (gcc.getVisitorIterationNumber() != tracker) {
                    gcc.setVisitorIterationNumber(tracker);
                    nextConnections.add(gc);
                }
                if (tracker == gn.visitorIterationNumber) continue;
                gn.visitorIterationNumber = tracker;
                nextRun.add(gn);
            }
        }
    }

    private void visitorNode(Object tracker, IGridVisitor g, Deque<GridNode> nextRun) {
        if (g.visitNode(this)) {
            for (IGridConnection gc : this.getConnections()) {
                GridNode gn = (GridNode)gc.getOtherSide(this);
                if (tracker == gn.visitorIterationNumber) continue;
                gn.visitorIterationNumber = tracker;
                nextRun.add(gn);
            }
        }
    }

    GridStorage getGridStorage() {
        return this.myStorage;
    }

    void setGridStorage(GridStorage s) {
        this.myStorage = s;
        this.usedChannels = 0;
        this.lastUsedChannels = 0;
    }

    @Override
    public void setAdHocChannels(int channels) {
        this.usedChannels = channels;
    }

    @Override
    public IPathItem getControllerRoute() {
        if (this.connections.isEmpty()) {
            throw new IllegalStateException(String.format("Node %s has no connections, cannot have a controller route!", this));
        }
        return this.connections.get(0);
    }

    @Nullable
    public GridNode getHighestSimilarAncestor() {
        return this.highestSimilarAncestor;
    }

    public boolean getSubtreeAllowsCompressedChannels() {
        return this.subtreeAllowsCompressedChannels;
    }

    @Override
    public void setControllerRoute(IPathItem fast) {
        this.usedChannels = 0;
        GridNode nodeParent = (GridNode)fast.getControllerRoute();
        if (nodeParent.getMachine() instanceof TileController) {
            this.highestSimilarAncestor = null;
            this.subtreeMaxChannels = this.getMaxChannels();
            this.subtreeAllowsCompressedChannels = !this.hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED);
        } else {
            this.highestSimilarAncestor = nodeParent.highestSimilarAncestor == null ? nodeParent : (nodeParent.subtreeMaxChannels == nodeParent.highestSimilarAncestor.subtreeMaxChannels ? nodeParent.highestSimilarAncestor : nodeParent);
            this.subtreeMaxChannels = Math.min(nodeParent.subtreeMaxChannels, this.getMaxChannels());
            this.subtreeAllowsCompressedChannels = nodeParent.subtreeAllowsCompressedChannels && !this.hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED);
        }
        GridConnection connection = (GridConnection)fast;
        int idx = this.connections.indexOf(connection);
        if (idx > 0) {
            this.connections.remove(connection);
            this.connections.add(0, connection);
        }
    }

    public int getMaxChannels() {
        return CHANNEL_COUNT[this.compressedData & 3];
    }

    @Override
    public IReadOnlyCollection<IPathItem> getPossibleOptions() {
        return new ReadOnlyCollection<IPathItem>((Collection<IPathItem>)this.connections);
    }

    public int propagateChannelsUpwards(boolean consumesChannel) {
        this.usedChannels = 0;
        for (GridConnection connection : this.connections) {
            if (connection.getControllerRoute() != this) continue;
            this.usedChannels += connection.usedChannels;
        }
        if (consumesChannel) {
            ++this.usedChannels;
        }
        if (this.usedChannels > this.getMaxChannels()) {
            AELog.error("Internal channel assignment error. Grid node {} has {} channels passing through it but it only supports up to {}. Please open an issue on the AE2 repository.", this, this.usedChannels, this.getMaxChannels());
        }
        return this.usedChannels;
    }

    @Override
    public void incrementChannelCount(int usedChannels) {
        this.usedChannels += usedChannels;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return this.gridProxy.getFlags();
    }

    @Override
    public void finalizeChannels() {
        this.highestSimilarAncestor = null;
        if (this.hasFlag(GridFlags.CANNOT_CARRY)) {
            return;
        }
        if (this.lastUsedChannels != this.usedChannels) {
            this.lastUsedChannels = this.usedChannels;
            if (this.getInternalGrid() != null) {
                this.getInternalGrid().postEventTo(this, EVENT);
            }
        }
    }

    public long getLastSecurityKey() {
        return this.lastSecurityKey;
    }

    public void setLastSecurityKey(long lastSecurityKey) {
        this.lastSecurityKey = lastSecurityKey;
    }

    public double getPreviousDraw() {
        return this.previousDraw;
    }

    public void setPreviousDraw(double previousDraw) {
        this.previousDraw = previousDraw;
    }

    private static class MachineSecurityBreak
    implements IWorldCallable<Void> {
        private final GridNode node;

        public MachineSecurityBreak(GridNode node) {
            this.node = node;
        }

        @Override
        public Void call(World world) throws Exception {
            this.node.getMachine().securityBreak();
            return null;
        }
    }
}

