/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.util.item.ItemFilterList;
import appeng.util.item.NetworkItemList;
import java.util.function.Predicate;

public class StorageBusInventoryHandler<T extends IAEStack<T>>
extends MEInventoryHandler<T> {
    public StorageBusInventoryHandler(IMEInventory<T> i, StorageChannel channel) {
        super(i, channel);
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out, int iteration) {
        if (!this.hasReadAccess && !this.isVisible()) {
            return out;
        }
        if (out instanceof ItemFilterList) {
            return this.getAvailableItemsFilter(out, iteration);
        }
        if (this.isExtractFilterActive() && !this.getExtractPartitionList().isEmpty()) {
            return this.filterAvailableItems(out, iteration);
        }
        return this.getAvailableItems(out, iteration, e -> true);
    }

    @Override
    protected IItemList<T> filterAvailableItems(IItemList<T> out, int iteration) {
        Predicate filterCondition = this.getExtractFilterCondition();
        return this.getAvailableItems(out, iteration, filterCondition);
    }

    private IItemList<T> getAvailableItems(IItemList<T> out, int iteration, Predicate<T> filterCondition) {
        IItemList availableItems = this.getInternal().getAvailableItems(this.getChannel().createList(), iteration);
        if (availableItems instanceof NetworkItemList) {
            NetworkItemList<IAEStack> networkItemList = new NetworkItemList<IAEStack>((NetworkItemList)availableItems);
            networkItemList.addFilter(filterCondition);
            return networkItemList;
        }
        for (IAEStack items : availableItems) {
            if (!filterCondition.test(items)) continue;
            out.add(items);
        }
        return out;
    }
}

