/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.helpers.MultiCraftingTracker;
import appeng.me.GridAccessException;
import appeng.me.cache.NetworkMonitor;
import appeng.parts.automation.PartSharedItemBus;
import appeng.util.InventoryAdaptor;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.OreFilteredList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class PartExportBus
extends PartSharedItemBus
implements ICraftingRequester {
    private final MultiCraftingTracker craftingTracker = new MultiCraftingTracker(this, 9);
    private final BaseActionSource mySrc;
    private long itemToSend = 1L;
    private boolean didSomething = false;
    private int nextSlot = 0;

    public PartExportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.mySrc = new MachineSource(this);
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.craftingTracker.readFromNBT(extra);
        this.nextSlot = extra.func_74762_e("nextSlot");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.craftingTracker.writeToNBT(extra);
        extra.func_74768_a("nextSlot", this.nextSlot);
    }

    @Override
    protected TickRateModulation doBusWork() {
        block14: {
            if (!this.getProxy().isActive() || !this.canDoBusWork()) {
                return TickRateModulation.IDLE;
            }
            this.itemToSend = this.calculateItemsToSend();
            this.didSomething = false;
            try {
                InventoryAdaptor destination = this.getHandler();
                IMEMonitor<IAEItemStack> gridInv = this.getProxy().getStorage().getItemInventory();
                IEnergyGrid energy = this.getProxy().getEnergy();
                ICraftingGrid cg = this.getProxy().getCrafting();
                FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
                SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
                if (destination != null) {
                    if (this.getInstalledUpgrades(Upgrades.ORE_FILTER) == 0) {
                        int x = 0;
                        for (x = 0; x < this.availableSlots() && this.itemToSend > 0L; ++x) {
                            int slotToExport = this.getStartingSlot(schedulingMode, x);
                            IAEItemStack ais = this.getConfig().getAEStackInSlot(slotToExport);
                            if (ais == null || this.itemToSend <= 0L || this.craftOnly()) {
                                if (!this.isCraftingEnabled()) continue;
                                this.didSomething = this.craftingTracker.handleCrafting(slotToExport, this.itemToSend, ais, destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.mySrc) || this.didSomething;
                                continue;
                            }
                            long before = this.itemToSend;
                            if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                                if (gridInv instanceof NetworkMonitor) {
                                    Collection<IAEItemStack> fzlist = ((NetworkMonitor)gridInv).getHandler().getSortedFuzzyItems(new ArrayList(), ais, fzMode, IterationCounter.fetchNewId());
                                    for (IAEItemStack o : fzlist) {
                                        this.pushItemIntoTarget(destination, energy, gridInv, o);
                                    }
                                    if (this.itemToSend <= 0L) {
                                        break;
                                    }
                                }
                            } else {
                                this.pushItemIntoTarget(destination, energy, gridInv, ais);
                            }
                            if (this.itemToSend != before || !this.isCraftingEnabled()) continue;
                            this.didSomething = this.craftingTracker.handleCrafting(slotToExport, this.itemToSend, ais, destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.mySrc) || this.didSomething;
                        }
                        this.updateSchedulingMode(schedulingMode, x);
                        break block14;
                    }
                    if (this.oreFilterString.isEmpty()) break block14;
                    if (this.filterPredicate == null) {
                        this.filterPredicate = OreFilteredList.makeFilter(this.oreFilterString);
                    }
                    for (IAEItemStack stack : gridInv.getStorageList()) {
                        if (stack == null || this.filterPredicate == null || !this.filterPredicate.test(stack)) continue;
                        this.pushItemIntoTarget(destination, energy, gridInv, stack);
                        if (this.itemToSend > 0L) continue;
                        break block14;
                    }
                    break block14;
                }
                return TickRateModulation.SLEEP;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return this.didSomething ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        rh.setTexture(CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_BUS);
            return true;
        }
        return false;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ExportBus.getMin(), TickRates.ExportBus.getMax(), this.isSleeping(), false);
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        InventoryAdaptor d = this.getHandler();
        try {
            double power;
            IEnergyGrid energy;
            if (d != null && this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = (double)items.getStackSize(), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                if (mode == Actionable.MODULATE) {
                    return AEItemStack.create(d.addItems(items.getItemStack()));
                }
                return AEItemStack.create(d.simulateAdd(items.getItemStack()));
            }
        }
        catch (GridAccessException e) {
            AELog.debug(e);
        }
        return items;
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    private boolean craftOnly() {
        return this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.getInstalledUpgrades(Upgrades.CRAFTING) > 0;
    }

    private void pushItemIntoTarget(InventoryAdaptor d, IEnergyGrid energy, IMEInventory<IAEItemStack> inv, IAEItemStack ais) {
        long canFit;
        ItemStack is = ais.getItemStack();
        is.field_77994_a = (int)this.itemToSend;
        ItemStack o = d.simulateAdd(is);
        long l = canFit = o == null ? this.itemToSend : this.itemToSend - (long)o.field_77994_a;
        if (canFit > 0L) {
            ais = ais.copy();
            ais.setStackSize(canFit);
            IAEItemStack itemsToAdd = Platform.poweredExtraction(energy, inv, ais, this.mySrc);
            if (itemsToAdd != null) {
                this.itemToSend -= itemsToAdd.getStackSize();
                ItemStack failed = d.addItems(itemsToAdd.getItemStack());
                if (failed != null) {
                    ais.setStackSize(failed.field_77994_a);
                    inv.injectItems(ais, Actionable.MODULATE, this.mySrc);
                } else {
                    this.didSomething = true;
                }
            }
        }
    }

    private int getStartingSlot(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.RANDOM) {
            return Platform.getRandom().nextInt(this.availableSlots());
        }
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            return (this.nextSlot + x) % this.availableSlots();
        }
        return x;
    }

    private void updateSchedulingMode(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            this.nextSlot = (this.nextSlot + x) % this.availableSlots();
        }
    }
}

