/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import com.google.common.base.Objects;
import java.util.EnumSet;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.config.MTConfig;
import yalter.mousetweaks.impl.IMouseState;
import yalter.mousetweaks.impl.MouseButton;

public class MouseState
implements IMouseState {
    private final EnumSet<MouseButton> pressedButtons = EnumSet.noneOf(MouseButton.class);
    private int scrollAmount = 0;
    public boolean simpleScrolling = false;

    @Override
    public void update() {
        MouseButton eventButton = MouseState.getEventButton();
        if (eventButton != null) {
            if (Mouse.getEventButtonState()) {
                this.pressedButtons.add(eventButton);
            } else {
                this.pressedButtons.remove((Object)eventButton);
            }
        } else if (!this.simpleScrolling) {
            this.scrollAmount += MTConfig.scrollItemScaling.scale(Mouse.getEventDWheel());
        }
        this.pressedButtons.removeIf(mouseButton -> !Mouse.isButtonDown((int)mouseButton.getValue()));
    }

    private static MouseButton getEventButton() {
        int eventButton = Mouse.getEventButton();
        if (eventButton == 0) {
            return MouseButton.LEFT;
        }
        if (eventButton == 1) {
            return MouseButton.RIGHT;
        }
        return null;
    }

    @Override
    public void clear() {
        this.pressedButtons.clear();
        this.scrollAmount = 0;
    }

    @Override
    public boolean isButtonPressed(MouseButton mouseButton) {
        return this.pressedButtons.contains((Object)mouseButton);
    }

    @Override
    public int consumeScrollAmount() {
        if (this.simpleScrolling) {
            this.scrollAmount += MTConfig.scrollItemScaling.scale(Mouse.getDWheel());
        }
        int amountConsumed = this.scrollAmount / 120;
        this.scrollAmount -= amountConsumed * 120;
        return amountConsumed;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("pressedButtons", (Object)this.pressedButtons.toArray()).add("scrollAmount", this.scrollAmount).toString();
    }
}

