/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.block;

import buildcraft.api.tools.IToolWrench;
import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ISturdyTrackExtendable;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSturdyRailBooster
extends BlockRailPowered
implements ISturdyTrackExtendable {
    public IIcon on;
    public IIcon off;

    public BlockSturdyRailBooster() {
        this.func_149647_a(CatwalkMod.catwalkTab);
        this.func_149672_a(CatwalkMod.catwalkSounds);
        this.func_149663_c("sturdy_booster_rail");
        this.func_149711_c(0.7f);
    }

    public boolean isFlexibleRail(IBlockAccess world, int y, int x, int z) {
        return !this.field_150053_a;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (CatwalkUtil.isHoldingWrench(player) && player.func_70093_af()) {
            ArrayList drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            for (ItemStack s : drops) {
                CatwalkUtil.giveItemToPlayer(player, s);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int blockSide, float hitX, float hitY, float hitZ) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ForgeDirection d = ForgeDirection.NORTH;
        switch (l) {
            case 0: {
                d = ForgeDirection.SOUTH;
                break;
            }
            case 1: {
                d = ForgeDirection.WEST;
                break;
            }
            case 2: {
                d = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                d = ForgeDirection.EAST;
            }
        }
        ItemStack held = player.func_71045_bC();
        if (held != null && held.func_77973_b() instanceof IToolWrench) {
            int meta = world.func_72805_g(x, y, z);
            meta = (meta & 8) == 0 ? (meta |= 8) : (meta &= 0xFFFFFFF7);
            world.func_72921_c(x, y, z, meta, 3);
        }
        if (blockSide == ForgeDirection.UP.ordinal() && held != null && held.func_77973_b() instanceof ItemBlock && ((ItemBlock)held.func_77973_b()).field_150939_a instanceof ISturdyTrackExtendable) {
            ItemBlock ib;
            if (this.func_149742_c(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ) && (ib = (ItemBlock)held.func_77973_b()).placeBlockAt(held, player, world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, d.getOpposite().ordinal(), d.offsetX > 0 ? 1.0f : 0.5f, 0.03125f, d.offsetZ > 0 ? 1.0f : 0.5f, held.func_77960_j()) && !player.field_71075_bZ.field_75098_d) {
                --held.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart cart, int x, int y, int z) {
        int railMeta = this.getBasicRailMetadata((IBlockAccess)world, cart, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        double d15 = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
        if ((meta & 8) == 0) {
            return;
        }
        if (d15 > 0.01) {
            double d16 = 0.06;
            cart.field_70159_w += cart.field_70159_w / d15 * d16;
            cart.field_70179_y += cart.field_70179_y / d15 * d16;
        } else if (railMeta == 1) {
            if (cart.field_70170_p.func_147439_a(x - 1, y, z).func_149721_r()) {
                cart.field_70159_w = 0.02;
            } else if (cart.field_70170_p.func_147439_a(x + 1, y, z).func_149721_r()) {
                cart.field_70159_w = -0.02;
            }
        } else if (railMeta == 0) {
            if (cart.field_70170_p.func_147439_a(x, y, z - 1).func_149721_r()) {
                cart.field_70179_y = 0.02;
            } else if (cart.field_70170_p.func_147439_a(x, y, z + 1).func_149721_r()) {
                cart.field_70179_y = -0.02;
            }
        }
    }

    public boolean func_150050_e() {
        return true;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, int y, int x, int z) {
        return super.getRailMaxSpeed(world, cart, y, x, z);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return "catwalks:blocks/sturdy_rail/booster";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return (p_149691_2_ & 8) == 0 ? this.off : this.on;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.on = reg.func_94245_a("catwalks:sturdy_rail/booster_on");
        this.off = reg.func_94245_a("catwalks:sturdy_rail/booster_off");
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (!world.field_72995_K) {
            int l;
            int i1 = l = world.func_72805_g(x, y, z);
            if (this.field_150053_a) {
                i1 = l & 7;
            }
            this.func_150052_a(world, x, y, z, (l & 8) > 1);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB blockBounds, List list, Entity entity) {
        if (entity instanceof EntityMinecart) {
            return;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(x + 0), (double)(y + 0), (double)(z + 0), (double)(x + 1), (double)((float)y + 0.0625f), (double)(z + 1));
        if (blockBounds.func_72326_a(aabb)) {
            list.add(aabb);
        }
    }
}

