/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import team.chisel.client.render.RendererSnakeStone;

public class BlockSnakestone
extends Block {
    static final int SEC_HEAD = 0;
    static final int SEC_DOWN = 4;
    static final int SEC_UP = 8;
    static final int SEC_HOR = 12;
    static final int SIDE_B = 0;
    static final int SIDE_T = 1;
    static final int SIDE_N = 2;
    static final int SIDE_S = 3;
    static final int SIDE_W = 4;
    static final int SIDE_E = 5;
    String iconPrefix;
    IIcon iconFaceLeft;
    IIcon iconFaceRight;
    IIcon iconCross;
    IIcon iconFace;
    IIcon iconTopTip;
    IIcon iconTopSide;
    IIcon iconBottom;
    IIcon iconBottomSide;
    IIcon iconBottomTip;
    IIcon iconLeftDown;
    IIcon iconRightDown;
    IIcon iconLeftUp;
    IIcon iconRightUp;
    IIcon iconLeftTip;
    IIcon iconSide;
    IIcon iconRightTip;
    IIcon iconTop;
    public boolean flipTopTextures;
    static final int[] rotRemap = new int[]{0, 3, 1, 2};

    public BlockSnakestone(String iconPrefix) {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149769_e);
        this.flipTopTextures = false;
        this.iconPrefix = iconPrefix;
    }

    public int func_149645_b() {
        return RendererSnakeStone.id;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 3) {
            return;
        }
        if (this.rotateHead(world, x, y, z) != -1) {
            return;
        }
        int rot = rotRemap[MathHelper.func_76128_c((double)((double)entity.field_70177_z * 4.0 / 360.0 + 0.5)) & 3];
        world.func_72921_c(x, y, z, rot, 3);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hx, float hy, float hz, int meta) {
        if (meta <= 3) {
            return meta;
        }
        if (this.rotateBodyPart(world, x, y, z)) {
            return world.func_72805_g(x, y, z);
        }
        if (side == 0 || side == 1) {
            meta = 14;
        }
        if (side == 2 || side == 3) {
            meta = 13;
        }
        if (side == 4 || side == 5) {
            meta = 12;
        }
        world.func_72921_c(x, y, z, meta, 2);
        return meta;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int kind = world.func_72805_g(x, y, z) & 0xC;
        if (kind == 0) {
            this.rotateHead(world, x, y, z);
        } else {
            this.rotateBodyPart(world, x, y, z);
        }
    }

    public int[] getConnections(World world, int ox, int oy, int oz) {
        int index = 0;
        int[] res = new int[]{-1, -1, -1, -1, -1, -1, -1};
        for (int direction = 0; direction < 6; ++direction) {
            int x = ox;
            int y = oy;
            int z = oz;
            switch (direction) {
                case 0: {
                    --z;
                    break;
                }
                case 1: {
                    ++z;
                    break;
                }
                case 2: {
                    --x;
                    break;
                }
                case 3: {
                    ++x;
                    break;
                }
                case 4: {
                    --y;
                    break;
                }
                case 5: {
                    ++y;
                }
            }
            if (!world.func_147439_a(x, y, z).equals((Object)this)) continue;
            boolean match = false;
            int px1 = x;
            int px2 = x;
            int py1 = y;
            int py2 = y;
            int pz1 = z;
            int pz2 = z;
            int meta = world.func_72805_g(x, y, z);
            if ((meta & 0xC) == 4 || (meta & 0xC) == 8) {
                py1 = (meta & 4) == 4 ? --py1 : ++py1;
                switch (meta & 3) {
                    case 0: {
                        --pz2;
                        break;
                    }
                    case 1: {
                        ++pz2;
                        break;
                    }
                    case 2: {
                        --px2;
                        break;
                    }
                    case 3: {
                        ++px2;
                    }
                }
            } else if (meta == 12) {
                --px1;
                ++px2;
            } else if (meta == 13) {
                --pz1;
                ++pz2;
            } else if (meta == 14) {
                --py1;
                ++py2;
            } else if (meta == 15) {
                match = true;
            } else if (meta < 4) {
                match = true;
            }
            if (!match) {
                Block b1 = world.func_147439_a(px1, py1, pz1);
                Block b2 = world.func_147439_a(px2, py2, pz2);
                if (b1 != this || b2 != this) {
                    match = true;
                }
                if (ox == px1 && oy == py1 && oz == pz1) {
                    match = true;
                }
                if (ox == px2 && oy == py2 && oz == pz2) {
                    match = true;
                }
            }
            if (!match) continue;
            res[index++] = direction;
        }
        if (index != 5) {
            res[index] = -1;
        }
        return res;
    }

    public boolean rotateBodyPart(World world, int x, int y, int z) {
        int[] con = this.getConnections(world, x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        if (con[1] == -1) {
            return false;
        }
        if (con[2] != -1) {
            return false;
        }
        int meta = 15;
        if (con[0] == 2 && con[1] == 3) {
            meta = 12;
        } else if (con[0] == 0 && con[1] == 1) {
            meta = 13;
        } else if (con[0] == 4 && con[1] == 5) {
            meta = 14;
        } else if (con[1] == 4) {
            meta = 4 | con[0];
        } else if (con[1] == 5) {
            meta = 8 | con[0];
        }
        if (blockMeta != meta) {
            world.func_72921_c(x, y, z, meta, 3);
        }
        return true;
    }

    public int rotateHead(World world, int x, int y, int z) {
        int[] con = this.getConnections(world, x, y, z);
        if (con[1] >= 0 && con[1] < 4) {
            return -1;
        }
        int meta = -1;
        switch (con[0]) {
            case 0: {
                meta = 1;
                break;
            }
            case 1: {
                meta = 0;
                break;
            }
            case 2: {
                meta = 3;
                break;
            }
            case 3: {
                meta = 2;
            }
        }
        if (meta == -1) {
            return -1;
        }
        world.func_147465_d(x, y, z, (Block)this, meta, 3);
        return meta;
    }

    public boolean connectedTo(World par1World, int x, int y, int z, int direction) {
        switch (direction) {
            case 0: {
                return par1World.func_147439_a(x, y, z - 1).equals((Object)this);
            }
            case 1: {
                return par1World.func_147439_a(x, y, z + 1).equals((Object)this);
            }
            case 2: {
                return par1World.func_147439_a(x - 1, y, z).equals((Object)this);
            }
            case 3: {
                return par1World.func_147439_a(x + 1, y, z).equals((Object)this);
            }
            case 4: {
                return par1World.func_147439_a(x, y - 1, z).equals((Object)this);
            }
            case 5: {
                return par1World.func_147439_a(x, y + 1, z).equals((Object)this);
            }
        }
        return false;
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (meta | side << 4) {
            case 12: {
                return this.iconBottomTip;
            }
            case 28: {
                return this.iconTopSide;
            }
            case 44: {
                return this.iconSide;
            }
            case 60: {
                return this.iconSide;
            }
            case 76: {
                return this.iconCross;
            }
            case 92: {
                return this.iconCross;
            }
            case 13: {
                return this.iconBottomTip;
            }
            case 29: {
                return this.iconTopSide;
            }
            case 45: {
                return this.iconCross;
            }
            case 61: {
                return this.iconCross;
            }
            case 77: {
                return this.iconSide;
            }
            case 93: {
                return this.iconSide;
            }
            case 14: {
                return this.iconCross;
            }
            case 30: {
                return this.iconCross;
            }
            case 46: {
                return this.iconSide;
            }
            case 62: {
                return this.iconSide;
            }
            case 78: {
                return this.iconSide;
            }
            case 94: {
                return this.iconSide;
            }
            case 15: {
                return this.iconBottom;
            }
            case 31: {
                return this.iconTop;
            }
            case 47: {
                return this.iconSide;
            }
            case 63: {
                return this.iconSide;
            }
            case 79: {
                return this.iconSide;
            }
            case 95: {
                return this.iconSide;
            }
            case 4: {
                return this.iconCross;
            }
            case 20: {
                return this.iconTopTip;
            }
            case 36: {
                return this.iconCross;
            }
            case 52: {
                return this.iconRightTip;
            }
            case 68: {
                return this.iconLeftDown;
            }
            case 84: {
                return this.iconRightDown;
            }
            case 5: {
                return this.iconCross;
            }
            case 21: {
                return this.iconTopTip;
            }
            case 37: {
                return this.iconLeftTip;
            }
            case 53: {
                return this.iconCross;
            }
            case 69: {
                return this.iconRightDown;
            }
            case 85: {
                return this.iconLeftDown;
            }
            case 6: {
                return this.iconCross;
            }
            case 22: {
                return this.iconTopTip;
            }
            case 38: {
                return this.iconRightDown;
            }
            case 54: {
                return this.iconLeftDown;
            }
            case 70: {
                return this.iconCross;
            }
            case 86: {
                return this.iconLeftTip;
            }
            case 7: {
                return this.iconCross;
            }
            case 23: {
                return this.iconTopTip;
            }
            case 39: {
                return this.iconLeftDown;
            }
            case 55: {
                return this.iconRightDown;
            }
            case 71: {
                return this.iconRightTip;
            }
            case 87: {
                return this.iconCross;
            }
            case 8: {
                return this.iconBottomSide;
            }
            case 24: {
                return this.iconCross;
            }
            case 40: {
                return this.iconCross;
            }
            case 56: {
                return this.iconLeftTip;
            }
            case 72: {
                return this.iconLeftUp;
            }
            case 88: {
                return this.iconRightUp;
            }
            case 9: {
                return this.iconBottomSide;
            }
            case 25: {
                return this.iconCross;
            }
            case 41: {
                return this.iconRightTip;
            }
            case 57: {
                return this.iconCross;
            }
            case 73: {
                return this.iconRightUp;
            }
            case 89: {
                return this.iconLeftUp;
            }
            case 10: {
                return this.iconBottomSide;
            }
            case 26: {
                return this.iconCross;
            }
            case 42: {
                return this.iconRightUp;
            }
            case 58: {
                return this.iconLeftUp;
            }
            case 74: {
                return this.iconCross;
            }
            case 90: {
                return this.iconRightTip;
            }
            case 11: {
                return this.iconBottomSide;
            }
            case 27: {
                return this.iconCross;
            }
            case 43: {
                return this.iconLeftUp;
            }
            case 59: {
                return this.iconRightUp;
            }
            case 75: {
                return this.iconLeftTip;
            }
            case 91: {
                return this.iconCross;
            }
            case 0: {
                return this.iconBottomSide;
            }
            case 16: {
                return this.iconTopTip;
            }
            case 32: {
                return this.iconFace;
            }
            case 48: {
                return this.iconCross;
            }
            case 64: {
                return this.iconFaceLeft;
            }
            case 80: {
                return this.iconFaceRight;
            }
            case 1: {
                return this.iconBottomSide;
            }
            case 17: {
                return this.iconTopTip;
            }
            case 33: {
                return this.iconCross;
            }
            case 49: {
                return this.iconFace;
            }
            case 65: {
                return this.iconFaceRight;
            }
            case 81: {
                return this.iconFaceLeft;
            }
            case 2: {
                return this.iconBottomSide;
            }
            case 18: {
                return this.iconTopTip;
            }
            case 34: {
                return this.iconFaceRight;
            }
            case 50: {
                return this.iconFaceLeft;
            }
            case 66: {
                return this.iconFace;
            }
            case 82: {
                return this.iconCross;
            }
            case 3: {
                return this.iconBottomSide;
            }
            case 19: {
                return this.iconTopTip;
            }
            case 35: {
                return this.iconFaceLeft;
            }
            case 51: {
                return this.iconFaceRight;
            }
            case 67: {
                return this.iconCross;
            }
            case 83: {
                return this.iconFace;
            }
        }
        return this.iconCross;
    }

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 13));
    }

    public int func_149692_a(int meta) {
        if (meta < 4) {
            return 1;
        }
        return 13;
    }

    public void func_149651_a(IIconRegister register) {
        this.iconFaceLeft = register.func_94245_a(this.iconPrefix + "face-left");
        this.iconFaceRight = register.func_94245_a(this.iconPrefix + "face-right");
        this.iconFace = register.func_94245_a(this.iconPrefix + "face");
        this.iconLeftUp = register.func_94245_a(this.iconPrefix + "left-up");
        this.iconLeftDown = register.func_94245_a(this.iconPrefix + "left-down");
        this.iconLeftTip = register.func_94245_a(this.iconPrefix + "left-tip");
        this.iconRightUp = register.func_94245_a(this.iconPrefix + "right-up");
        this.iconRightDown = register.func_94245_a(this.iconPrefix + "right-down");
        this.iconRightTip = register.func_94245_a(this.iconPrefix + "right-tip");
        this.iconTop = register.func_94245_a(this.iconPrefix + "top");
        this.iconTopTip = register.func_94245_a(this.iconPrefix + "top-tip");
        this.iconTopSide = register.func_94245_a(this.iconPrefix + "top-side");
        this.iconBottom = register.func_94245_a(this.iconPrefix + "bot");
        this.iconBottomTip = register.func_94245_a(this.iconPrefix + "bot-tip");
        this.iconBottomSide = register.func_94245_a(this.iconPrefix + "bot-side");
        this.iconCross = register.func_94245_a(this.iconPrefix + "crosssection");
        this.iconSide = register.func_94245_a(this.iconPrefix + "side");
    }
}

