/*
 * Decompiled with CFR 0.152.
 */
package coint.config;

import coint.CointCore;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class CointConfig {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_EPOCHSYNC = "epochsync";
    public static final String CATEGORY_ENTITYSTATS = "entitystats";
    public static final String CATEGORY_API = "api";
    public static final String CATEGORY_DEBUG = "debug";
    private static Configuration config;
    public static String greeting;
    public static boolean epochSyncEnabled;
    public static boolean autoSyncOnQuestComplete;
    public static boolean partySyncEnabled;
    public static boolean syncNewPartyMembers;
    public static boolean autoParseRewardCommands;
    public static boolean entityStatsEnabled;
    public static int entityStatsIntervalMinutes;
    public static int entityStatsTopChunks;
    public static String apiUrl;
    public static int apiTimeout;
    public static boolean debugMode;
    public static boolean verboseLogging;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            CointConfig.loadConfig();
        }
    }

    public static void loadConfig() {
        try {
            config.load();
            config.addCustomCategoryComment(CATEGORY_GENERAL, "General CointCore settings");
            greeting = config.getString("greeting", CATEGORY_GENERAL, greeting, "Greeting message shown on startup");
            config.addCustomCategoryComment(CATEGORY_EPOCHSYNC, "Epoch synchronization settings");
            epochSyncEnabled = config.getBoolean("enabled", CATEGORY_EPOCHSYNC, epochSyncEnabled, "Enable epoch synchronization module");
            autoSyncOnQuestComplete = config.getBoolean("autoSyncOnQuestComplete", CATEGORY_EPOCHSYNC, autoSyncOnQuestComplete, "Automatically sync rank when a quest is completed");
            partySyncEnabled = config.getBoolean("partySyncEnabled", CATEGORY_EPOCHSYNC, partySyncEnabled, "Sync ranks to all party members when a quest is completed");
            syncNewPartyMembers = config.getBoolean("syncNewPartyMembers", CATEGORY_EPOCHSYNC, syncNewPartyMembers, "Sync ranks to new players when they join a party");
            autoParseRewardCommands = config.getBoolean("autoParseRewardCommands", CATEGORY_EPOCHSYNC, autoParseRewardCommands, "Automatically parse /ranks add commands from quest rewards (no manual quest ID mapping needed)");
            config.addCustomCategoryComment(CATEGORY_ENTITYSTATS, "Entity statistics logging settings. Logs top chunks by entity count to logs/mobstat.log");
            entityStatsEnabled = config.getBoolean("enabled", CATEGORY_ENTITYSTATS, entityStatsEnabled, "Enable entity statistics logging");
            entityStatsIntervalMinutes = config.getInt("intervalMinutes", CATEGORY_ENTITYSTATS, entityStatsIntervalMinutes, 1, 60, "Interval between statistics collection (in minutes)");
            entityStatsTopChunks = config.getInt("topChunks", CATEGORY_ENTITYSTATS, entityStatsTopChunks, 1, 50, "Number of top chunks to log");
            config.addCustomCategoryComment(CATEGORY_API, "External API settings");
            apiUrl = config.getString("url", CATEGORY_API, apiUrl, "Base URL for external API (leave empty to use API_URL env variable)");
            apiTimeout = config.getInt("timeout", CATEGORY_API, apiTimeout, 1000, 60000, "API request timeout in milliseconds");
            config.addCustomCategoryComment(CATEGORY_DEBUG, "Debug settings");
            debugMode = config.getBoolean("debugMode", CATEGORY_DEBUG, debugMode, "Enable debug mode");
            verboseLogging = config.getBoolean("verboseLogging", CATEGORY_DEBUG, verboseLogging, "Enable verbose logging");
        }
        catch (Exception e) {
            CointCore.LOG.error("Error loading config: {}", new Object[]{e.getMessage()});
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static String getEffectiveApiUrl() {
        if (apiUrl != null && !apiUrl.isEmpty()) {
            return apiUrl;
        }
        return System.getenv("API_URL");
    }

    public static boolean isApiConfigured() {
        String url = CointConfig.getEffectiveApiUrl();
        return url != null && !url.isEmpty();
    }

    public static Configuration getConfig() {
        return config;
    }

    static {
        greeting = "Hello from CointCore!";
        epochSyncEnabled = true;
        autoSyncOnQuestComplete = true;
        partySyncEnabled = true;
        syncNewPartyMembers = true;
        autoParseRewardCommands = true;
        entityStatsEnabled = true;
        entityStatsIntervalMinutes = 5;
        entityStatsTopChunks = 10;
        apiUrl = "";
        apiTimeout = 10000;
        debugMode = false;
        verboseLogging = false;
    }
}

