/*
 * Decompiled with CFR 0.152.
 */
package coint.integration.betterquesting;

import betterquesting.api.events.QuestEvent;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.storage.DBEntry;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyManager;
import bq_standard.rewards.RewardCommand;
import coint.config.CointConfig;
import coint.integration.serverutilities.SURanksManager;
import coint.module.epochsync.EpochRegistry;
import coint.util.CommandParser;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BQEventListener {
    private static final Logger LOG = LogManager.getLogger(BQEventListener.class);

    @SubscribeEvent
    public void onQuestComplete(QuestEvent event) {
        if (event.getType() != QuestEvent.Type.COMPLETED || event.getQuestIDs().isEmpty()) {
            return;
        }
        if (!CointConfig.autoSyncOnQuestComplete) {
            LOG.debug("Auto sync on quest complete is disabled");
            return;
        }
        UUID playerId = event.getPlayerID();
        LOG.debug("Quest completion event for player {}, quest IDs: {}", new Object[]{playerId, event.getQuestIDs()});
        for (UUID questID : event.getQuestIDs()) {
            this.processQuestCompletion(playerId, questID);
        }
    }

    private void processQuestCompletion(UUID playerId, UUID questID) {
        LOG.debug("Processing quest completion: {}", new Object[]{questID});
        String epoch = EpochRegistry.getEpochForQuest(questID);
        if (epoch == null) {
            epoch = this.parseRankFromQuestRewards(questID);
        }
        if (epoch == null) {
            LOG.debug("Quest {} is not an epoch quest (no mapping and no rank command found)", new Object[]{questID});
            return;
        }
        LOG.info("Quest {} triggers rank: {}", new Object[]{questID, epoch});
        this.assignRankToPlayerAndParty(playerId, epoch);
    }

    private String parseRankFromQuestRewards(UUID questID) {
        try {
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.get((Object)questID);
            if (quest == null) {
                LOG.debug("Quest {} not found in database", new Object[]{questID});
                return null;
            }
            for (DBEntry rewardEntry : quest.getRewards().getEntries()) {
                IReward reward = (IReward)rewardEntry.getValue();
                if (!(reward instanceof RewardCommand)) continue;
                RewardCommand cmdReward = (RewardCommand)reward;
                String command = cmdReward.command;
                if (!CommandParser.isRanksAddCommand(command)) continue;
                String rank = CommandParser.parseRankFromCommand(command);
                if (rank != null && EpochRegistry.isEpoch(rank)) {
                    LOG.debug("Found epoch rank '{}' in quest reward command: {}", new Object[]{rank, command});
                    return rank;
                }
                if (rank == null) continue;
                LOG.debug("Rank '{}' from command is not a registered epoch, skipping", new Object[]{rank});
            }
        }
        catch (Exception e) {
            LOG.error("Error parsing quest rewards for {}: {}", new Object[]{questID, e.getMessage(), e});
        }
        return null;
    }

    private void assignRankToPlayerAndParty(UUID playerId, String rank) {
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null) {
            LOG.warn("SURanksManager not initialized, cannot set rank");
            return;
        }
        IParty party = this.getPlayerParty(playerId);
        if (party != null && CointConfig.partySyncEnabled) {
            List members = party.getMembers();
            LOG.info("Assigning rank {} to {} party members", new Object[]{rank, members.size()});
            for (UUID memberUUID : members) {
                this.assignRankToPlayer(ranksManager, memberUUID, rank);
            }
        } else {
            this.assignRankToPlayer(ranksManager, playerId, rank);
        }
    }

    private void assignRankToPlayer(SURanksManager ranksManager, UUID playerId, String rank) {
        try {
            ranksManager.setRank(playerId, rank);
            LOG.info("Successfully set rank {} for player {}", new Object[]{rank, playerId});
        }
        catch (Exception e) {
            LOG.error("Error setting rank {} for player {}: {}", new Object[]{rank, playerId, e.getMessage(), e});
        }
    }

    private IParty getPlayerParty(UUID playerId) {
        try {
            DBEntry entry = PartyManager.INSTANCE.getParty(playerId);
            return entry != null ? (IParty)entry.getValue() : null;
        }
        catch (Exception e) {
            LOG.debug("Could not get party for player {}: {}", new Object[]{playerId, e.getMessage()});
            return null;
        }
    }

    public String getHighestPartyEpoch(IParty party) {
        if (party == null) {
            return null;
        }
        String highestEpoch = null;
        int highestPriority = -1;
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null) {
            return null;
        }
        for (UUID memberUUID : party.getMembers()) {
            int priority;
            String memberEpoch = this.getPlayerCurrentEpoch(memberUUID);
            if (memberEpoch == null || (priority = EpochRegistry.getEpochPriority(memberEpoch)) <= highestPriority) continue;
            highestPriority = priority;
            highestEpoch = memberEpoch;
        }
        return highestEpoch;
    }

    private String getPlayerCurrentEpoch(UUID playerId) {
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null) {
            return null;
        }
        try {
            return ranksManager.getPlayerEpoch(playerId);
        }
        catch (Exception e) {
            LOG.debug("Could not get epoch for player {}: {}", new Object[]{playerId, e.getMessage()});
            return null;
        }
    }

    public void syncPlayerToParty(UUID playerId) {
        IParty party = this.getPlayerParty(playerId);
        if (party == null) {
            LOG.debug("Player {} is not in a party, nothing to sync", new Object[]{playerId});
            return;
        }
        String partyEpoch = this.getHighestPartyEpoch(party);
        if (partyEpoch == null) {
            LOG.debug("Party has no epoch rank, nothing to sync for player {}", new Object[]{playerId});
            return;
        }
        String playerEpoch = this.getPlayerCurrentEpoch(playerId);
        if (playerEpoch == null || EpochRegistry.getEpochPriority(partyEpoch) > EpochRegistry.getEpochPriority(playerEpoch)) {
            LOG.info("Syncing player {} to party epoch: {}", new Object[]{playerId, partyEpoch});
            this.assignRankToPlayer(SURanksManager.getInstance(), playerId, partyEpoch);
        } else {
            LOG.debug("Player {} already has equal or higher epoch: {}", new Object[]{playerId, playerEpoch});
        }
    }
}

