/*
 * Decompiled with CFR 0.152.
 */
package coint.integration.betterquesting;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.party.IParty;
import betterquesting.api2.storage.DBEntry;
import betterquesting.questing.party.PartyManager;
import coint.config.CointConfig;
import coint.integration.serverutilities.SURanksManager;
import coint.module.epochsync.EpochRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartyEventListener {
    private static final Logger LOG = LogManager.getLogger(PartyEventListener.class);

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!CointConfig.syncNewPartyMembers || !CointConfig.partySyncEnabled) {
            return;
        }
        EntityPlayer player = event.player;
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        UUID playerId = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        LOG.debug("Player {} logged in, checking party sync", new Object[]{playerId});
        this.scheduleDelayedSync(playerId);
    }

    private void scheduleDelayedSync(UUID playerId) {
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.syncPlayerToParty(playerId);
            }
            catch (InterruptedException e) {
                LOG.debug("Sync thread interrupted for player {}", new Object[]{playerId});
            }
        }).start();
    }

    public void syncPlayerToParty(UUID playerId) {
        IParty party = this.getPlayerParty(playerId);
        if (party == null) {
            LOG.debug("Player {} is not in a party, nothing to sync", new Object[]{playerId});
            return;
        }
        String partyEpoch = this.getHighestPartyEpoch(party);
        if (partyEpoch == null) {
            LOG.debug("Party has no epoch rank, nothing to sync for player {}", new Object[]{playerId});
            return;
        }
        String playerEpoch = this.getPlayerCurrentEpoch(playerId);
        if (playerEpoch == null || EpochRegistry.getEpochPriority(partyEpoch) > EpochRegistry.getEpochPriority(playerEpoch)) {
            LOG.info("Syncing player {} to party epoch: {} (was: {})", new Object[]{playerId, partyEpoch, playerEpoch});
            this.assignRankToPlayer(playerId, partyEpoch);
        } else {
            LOG.debug("Player {} already has equal or higher epoch: {}", new Object[]{playerId, playerEpoch});
        }
    }

    public void onPlayerJoinParty(UUID playerId, IParty party) {
        if (!CointConfig.syncNewPartyMembers || !CointConfig.partySyncEnabled) {
            LOG.debug("Party sync disabled, skipping sync for player {}", new Object[]{playerId});
            return;
        }
        LOG.info("Player {} joined a party, syncing rank", new Object[]{playerId});
        this.syncPlayerToPartyInternal(playerId, party);
    }

    private void syncPlayerToPartyInternal(UUID playerId, IParty party) {
        String partyEpoch = this.getHighestPartyEpoch(party);
        if (partyEpoch == null) {
            LOG.debug("Party has no epoch rank, nothing to sync for new member {}", new Object[]{playerId});
            return;
        }
        String playerEpoch = this.getPlayerCurrentEpoch(playerId);
        if (playerEpoch == null || EpochRegistry.getEpochPriority(partyEpoch) > EpochRegistry.getEpochPriority(playerEpoch)) {
            LOG.info("Syncing new party member {} to epoch: {}", new Object[]{playerId, partyEpoch});
            this.assignRankToPlayer(playerId, partyEpoch);
        }
    }

    private IParty getPlayerParty(UUID playerId) {
        try {
            DBEntry entry = PartyManager.INSTANCE.getParty(playerId);
            return entry != null ? (IParty)entry.getValue() : null;
        }
        catch (Exception e) {
            LOG.debug("Could not get party for player {}: {}", new Object[]{playerId, e.getMessage()});
            return null;
        }
    }

    private String getHighestPartyEpoch(IParty party) {
        if (party == null) {
            return null;
        }
        String highestEpoch = null;
        int highestPriority = -1;
        for (UUID memberUUID : party.getMembers()) {
            int priority;
            String memberEpoch = this.getPlayerCurrentEpoch(memberUUID);
            if (memberEpoch == null || (priority = EpochRegistry.getEpochPriority(memberEpoch)) <= highestPriority) continue;
            highestPriority = priority;
            highestEpoch = memberEpoch;
        }
        return highestEpoch;
    }

    private String getPlayerCurrentEpoch(UUID playerId) {
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null || !ranksManager.isReady()) {
            return null;
        }
        try {
            return ranksManager.getPlayerEpoch(playerId);
        }
        catch (Exception e) {
            LOG.debug("Could not get epoch for player {}: {}", new Object[]{playerId, e.getMessage()});
            return null;
        }
    }

    private void assignRankToPlayer(UUID playerId, String rank) {
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null) {
            LOG.warn("SURanksManager not initialized, cannot set rank");
            return;
        }
        try {
            ranksManager.setRank(playerId, rank);
            LOG.info("Successfully set rank {} for player {}", new Object[]{rank, playerId});
        }
        catch (Exception e) {
            LOG.error("Error setting rank {} for player {}: {}", new Object[]{rank, playerId, e.getMessage(), e});
        }
    }
}

