/*
 * Decompiled with CFR 0.152.
 */
package coint.integration.serverutilities;

import coint.config.CointConfig;
import coint.module.epochsync.EpochRegistry;
import coint.util.HttpUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.ranks.PlayerRank;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;

public class SURanksManager {
    private static final Logger LOG = LogManager.getLogger(SURanksManager.class);
    private static SURanksManager INSTANCE;
    private Ranks ranksInst;
    private final Map<String, List<Rank.Entry>> epochPermissions = new HashMap<String, List<Rank.Entry>>();

    private SURanksManager() {
        this.initEpochPermissions();
    }

    public static void init() {
        if (INSTANCE == null) {
            INSTANCE = new SURanksManager();
            LOG.info("SURanksManager initialized");
        }
    }

    public static SURanksManager getInstance() {
        return INSTANCE;
    }

    private Ranks getRanksInstance() {
        if (this.ranksInst == null) {
            this.ranksInst = Ranks.INSTANCE;
            if (this.ranksInst == null) {
                LOG.error("Ranks.INSTANCE is null! ServerUtilities ranks not initialized yet.");
            } else {
                LOG.debug("Ranks instance obtained successfully");
            }
        }
        return this.ranksInst;
    }

    private void initEpochPermissions() {
        this.epochPermissions.put("bravebro", SURanksManager.createEpochPerms(1, 25, 10, 1));
        this.epochPermissions.put("stone", SURanksManager.createEpochPerms(2, 35, 15, 2));
        this.epochPermissions.put("steam", SURanksManager.createEpochPerms(3, 45, 20, 3));
        this.epochPermissions.put("lv", SURanksManager.createEpochPerms(4, 55, 25, 4));
        this.epochPermissions.put("mv", SURanksManager.createEpochPerms(5, 65, 30, 5));
        this.epochPermissions.put("hv", SURanksManager.createEpochPerms(6, 75, 35, 6));
        this.epochPermissions.put("ev", SURanksManager.createEpochPerms(7, 85, 40, 7));
        this.epochPermissions.put("iv", SURanksManager.createEpochPerms(8, 95, 45, 8));
        this.epochPermissions.put("luv", SURanksManager.createEpochPerms(9, 105, 50, 9));
        this.epochPermissions.put("zpm", SURanksManager.createEpochPerms(10, 115, 55, 10));
        this.epochPermissions.put("uv", SURanksManager.createEpochPerms(11, 125, 60, 11));
        this.epochPermissions.put("uhv", SURanksManager.createEpochPerms(12, 135, 65, 12));
        this.epochPermissions.put("uev", SURanksManager.createEpochPerms(13, 145, 70, 13));
        this.epochPermissions.put("uiv", SURanksManager.createEpochPerms(14, 155, 75, 14));
        this.epochPermissions.put("umv", SURanksManager.createEpochPerms(15, 165, 80, 15));
        this.epochPermissions.put("uxv", SURanksManager.createEpochPerms(16, 175, 85, 16));
        this.epochPermissions.put("stargateowner", SURanksManager.createEpochPerms(17, 200, 100, 20));
    }

    private static List<Rank.Entry> createEpochPerms(int priority, int chunks, int forcedChunks, int homes) {
        Rank.Entry p = new Rank.Entry("priority");
        p.value = String.valueOf(priority);
        Rank.Entry c = new Rank.Entry("serverutilities.claims.max_chunks");
        c.value = String.valueOf(chunks);
        Rank.Entry f = new Rank.Entry("serverutilities.chunkloader.max_chunks");
        f.value = String.valueOf(forcedChunks);
        Rank.Entry h = new Rank.Entry("serverutilities.homes.max");
        h.value = String.valueOf(homes);
        return Arrays.asList(p, c, f, h);
    }

    public Map<String, Rank> getRanks() {
        Ranks ranks = this.getRanksInstance();
        return ranks != null ? ranks.ranks : null;
    }

    public void setRank(UUID playerId, String rank) throws Exception {
        Ranks ranks = this.getRanksInstance();
        if (ranks == null) {
            throw new Exception("ServerUtilities Ranks not initialized yet");
        }
        PlayerRank playerRank = (PlayerRank)ranks.playerRanks.get(playerId);
        if (playerRank == null) {
            LOG.warn("Player {} not found in playerRanks, creating new entry", new Object[]{playerId});
            ForgePlayer forgePlayer = ranks.universe.getPlayer(playerId);
            if (forgePlayer != null) {
                playerRank = ranks.getPlayerRank(forgePlayer.getProfile());
            } else {
                throw new Exception("Player rank not found for " + playerId + " and player not in universe");
            }
        }
        ArrayList<Rank> epochsToRemove = new ArrayList<Rank>();
        for (Rank parent : playerRank.getParents()) {
            if (!EpochRegistry.isEpoch(parent.getId())) continue;
            epochsToRemove.add(parent);
        }
        for (Rank epochToRemove : epochsToRemove) {
            playerRank.removeParent(epochToRemove);
            LOG.debug("Removed epoch rank {} from player {}", new Object[]{epochToRemove.getId(), playerId});
        }
        Rank epochRank = ranks.getRank(rank);
        if (epochRank != null) {
            playerRank.addParent(epochRank);
            ranks.save();
            LOG.info("Set rank {} for player {}", new Object[]{rank, playerId});
        } else {
            LOG.warn("Epoch rank {} not found in ServerUtilities", new Object[]{rank});
        }
        this.notifyApiRankChange(playerId, rank);
    }

    private void notifyApiRankChange(UUID playerId, String rank) {
        String apiUrl = CointConfig.getEffectiveApiUrl();
        if (apiUrl == null || apiUrl.isEmpty()) {
            LOG.debug("API URL not configured, skipping notification");
            return;
        }
        JsonObject data = new JsonObject();
        data.addProperty("player_id", playerId.toString());
        data.addProperty("rank", rank);
        ((CompletableFuture)HttpUtil.postJsonAsync(apiUrl + "/api/coint-connector/roles/gtnh", data.toString()).thenAccept(code -> LOG.debug("API notification sent, response: {}", new Object[]{code}))).exceptionally(e -> {
            LOG.error("API notification failed: {}", new Object[]{e.getMessage()});
            return null;
        });
    }

    public void syncRanks(boolean onlyRoles) {
        Ranks ranks = this.getRanksInstance();
        if (ranks == null) {
            LOG.error("Cannot sync ranks: ServerUtilities Ranks not initialized");
            return;
        }
        String apiUrl = CointConfig.getEffectiveApiUrl();
        if (apiUrl == null || apiUrl.isEmpty()) {
            LOG.warn("API URL not configured, cannot sync ranks");
            return;
        }
        JsonObject data = new JsonObject();
        JsonArray ranksArray = new JsonArray();
        for (Rank r : ranks.ranks.values()) {
            JsonObject rankObj = new JsonObject();
            rankObj.addProperty("name", r.getId());
            rankObj.addProperty("power", (Number)r.getPriority());
            ranksArray.add((JsonElement)rankObj);
        }
        data.add("ranks", (JsonElement)ranksArray);
        if (!onlyRoles) {
            JsonArray playersArray = new JsonArray();
            for (PlayerRank p : ranks.playerRanks.values()) {
                JsonObject playerObj = new JsonObject();
                playerObj.addProperty("player_id", p.uuid.toString());
                boolean hasEpoch = false;
                for (Rank par : p.getActualParents()) {
                    if (!EpochRegistry.isEpoch(par.getId())) continue;
                    playerObj.addProperty("rank", par.getId());
                    hasEpoch = true;
                    break;
                }
                if (!hasEpoch) continue;
                playersArray.add((JsonElement)playerObj);
            }
            data.add("players", (JsonElement)playersArray);
        }
        ((CompletableFuture)HttpUtil.postJsonAsync(apiUrl + "/api/coint-connector/roles/sync", data.toString()).thenAccept(code -> LOG.info("Rank sync completed, response: {}", new Object[]{code}))).exceptionally(e -> {
            LOG.error("Rank sync failed: {}", new Object[]{e.getMessage()});
            return null;
        });
    }

    public List<Rank.Entry> getEpochPermissions(String epoch) {
        return this.epochPermissions.get(epoch);
    }

    public boolean isReady() {
        return this.getRanksInstance() != null;
    }

    public Universe getUniverse() {
        Ranks ranks = this.getRanksInstance();
        return ranks != null ? ranks.universe : null;
    }

    public String getPlayerEpoch(UUID playerId) {
        Ranks ranks = this.getRanksInstance();
        if (ranks == null) {
            LOG.debug("Cannot get player epoch: Ranks not initialized");
            return null;
        }
        PlayerRank playerRank = (PlayerRank)ranks.playerRanks.get(playerId);
        if (playerRank == null) {
            LOG.debug("Player {} not found in playerRanks", new Object[]{playerId});
            return null;
        }
        String highestEpoch = null;
        int highestPriority = -1;
        for (Rank parent : playerRank.getActualParents()) {
            int priority;
            String rankId = parent.getId();
            if (!EpochRegistry.isEpoch(rankId) || (priority = EpochRegistry.getEpochPriority(rankId)) <= highestPriority) continue;
            highestPriority = priority;
            highestEpoch = rankId;
        }
        return highestEpoch;
    }

    public boolean hasEpochOrHigher(UUID playerId, String epoch) {
        String playerEpoch = this.getPlayerEpoch(playerId);
        if (playerEpoch == null) {
            return false;
        }
        return EpochRegistry.getEpochPriority(playerEpoch) >= EpochRegistry.getEpochPriority(epoch);
    }
}

