/*
 * Decompiled with CFR 0.152.
 */
package coint.mixin;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CointMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.contains(".betterquesting.")) {
            return this.isModResourcePresent("/assets/betterquesting/");
        }
        if (mixinClassName.contains(".betterloadingscreen.")) {
            return this.isModResourcePresent("/assets/betterloadingscreen/");
        }
        if (mixinClassName.contains(".gregtech.")) {
            return this.isClassPresent("gregtech.api.GregTech_API");
        }
        if (mixinClassName.contains(".appliedenergistics2.")) {
            return this.isClassPresent("appeng.api.AEApi");
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return Collections.emptyList();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isModResourcePresent(String resourcePath) {
        return this.getClass().getResource(resourcePath) != null;
    }
}

