/*
 * Decompiled with CFR 0.152.
 */
package coint.module.entitystats;

import coint.CointCore;
import coint.config.CointConfig;
import coint.module.IModule;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class EntityStatsModule
implements IModule {
    public static final String ID = "entitystats";
    public static final String NAME = "Server Statistics";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int tickCounter = 0;
    private File logFile;
    private long[] tickTimes = new long[100];
    private int tickIndex = 0;
    private long lastTickTime = 0L;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        if (!this.isEnabled()) {
            CointCore.LOG.info("EntityStats module is disabled");
            return;
        }
        FMLCommonHandler.instance().bus().register((Object)this);
        CointCore.LOG.info("Server Statistics module enabled, logging every {} minutes", new Object[]{CointConfig.entityStatsIntervalMinutes});
    }

    @Override
    public boolean isEnabled() {
        return CointConfig.entityStatsEnabled;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        long now = System.nanoTime();
        if (this.lastTickTime != 0L) {
            this.tickTimes[this.tickIndex] = now - this.lastTickTime;
            this.tickIndex = (this.tickIndex + 1) % this.tickTimes.length;
        }
        this.lastTickTime = now;
        ++this.tickCounter;
        int intervalTicks = CointConfig.entityStatsIntervalMinutes * 20 * 60;
        if (this.tickCounter >= intervalTicks) {
            this.tickCounter = 0;
            this.collectAndLogStats();
        }
    }

    private double calculateTPS() {
        long total = 0L;
        int count = 0;
        for (long tickTime : this.tickTimes) {
            if (tickTime <= 0L) continue;
            total += tickTime;
            ++count;
        }
        if (count == 0) {
            return 20.0;
        }
        double avgTickMs = (double)(total / (long)count) / 1000000.0;
        return Math.min(20.0, 1000.0 / avgTickMs);
    }

    private void collectAndLogStats() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return;
        }
        ArrayList<ChunkStats> allChunkStats = new ArrayList<ChunkStats>();
        HashMap<String, Integer> globalTileEntityCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> globalEntityCounts = new HashMap<String, Integer>();
        HashMap<String, ItemInfo> droppedItemsDetails = new HashMap<String, ItemInfo>();
        int totalEntities = 0;
        int totalTileEntities = 0;
        int totalLoadedChunks = 0;
        int totalPlayers = 0;
        for (WorldServer world : server.field_71305_c) {
            if (world == null) continue;
            int dimensionId = world.field_73011_w.field_76574_g;
            ArrayList loadedChunks = new ArrayList(world.field_73059_b.field_73245_g);
            totalLoadedChunks += loadedChunks.size();
            for (Chunk chunk : loadedChunks) {
                ChunkStats stats = this.collectChunkStats(chunk, dimensionId, world);
                if (stats.totalEntities > 0 || stats.totalTileEntities > 0) {
                    allChunkStats.add(stats);
                }
                totalEntities += stats.totalEntities;
                totalTileEntities += stats.totalTileEntities;
                for (Map.Entry<String, Integer> entry : stats.entityCounts.entrySet()) {
                    globalEntityCounts.merge(entry.getKey(), entry.getValue(), Integer::sum);
                }
                for (Map.Entry<String, Integer> entry : stats.tileEntityCounts.entrySet()) {
                    globalTileEntityCounts.merge(entry.getKey(), entry.getValue(), Integer::sum);
                }
                for (Map.Entry<String, Object> entry : stats.droppedItems.entrySet()) {
                    droppedItemsDetails.merge(entry.getKey(), (ItemInfo)entry.getValue(), ItemInfo::merge);
                }
            }
            totalPlayers += world.field_73010_i.size();
        }
        allChunkStats.sort(Comparator.comparingInt(s -> s.totalEntities + s.totalTileEntities * 2).reversed());
        int topCount = Math.min(CointConfig.entityStatsTopChunks, allChunkStats.size());
        List<ChunkStats> topChunks = allChunkStats.subList(0, topCount);
        this.writeStatsToLog(topChunks, totalEntities, totalTileEntities, totalLoadedChunks, totalPlayers, globalEntityCounts, globalTileEntityCounts, droppedItemsDetails);
    }

    private ChunkStats collectChunkStats(Chunk chunk, int dimensionId, WorldServer world) {
        ChunkStats stats = new ChunkStats();
        stats.chunkX = chunk.field_76635_g;
        stats.chunkZ = chunk.field_76647_h;
        stats.dimensionId = dimensionId;
        stats.blockX = chunk.field_76635_g * 16 + 8;
        stats.blockY = 64;
        stats.blockZ = chunk.field_76647_h * 16 + 8;
        HashMap<String, Integer> entityCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> tileEntityCounts = new HashMap<String, Integer>();
        HashMap<String, ItemInfo> droppedItems = new HashMap<String, ItemInfo>();
        for (List entityList : chunk.field_76645_j) {
            for (Object obj : entityList) {
                EntityItem entityItem;
                ItemStack stack;
                if (!(obj instanceof Entity)) continue;
                Entity entity = (Entity)obj;
                String entityName = this.getEntityName(entity);
                entityCounts.merge(entityName, 1, Integer::sum);
                ++stats.totalEntities;
                if (entity instanceof EntityItem && (stack = (entityItem = (EntityItem)entity).func_92059_d()) != null) {
                    String itemKey = this.getItemKey(stack);
                    ItemInfo info = droppedItems.getOrDefault(itemKey, new ItemInfo(stack));
                    info.count += stack.field_77994_a;
                    ++info.entityCount;
                    info.addLocation(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, dimensionId);
                    droppedItems.put(itemKey, info);
                }
                if (!(entity instanceof EntityXPOrb)) continue;
                EntityXPOrb xp = (EntityXPOrb)entity;
                String xpKey = "XPOrb";
                ItemInfo info = droppedItems.getOrDefault(xpKey, new ItemInfo("XP Orb", 0));
                info.count += xp.field_70530_e;
                ++info.entityCount;
                info.addLocation(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, dimensionId);
                droppedItems.put(xpKey, info);
            }
        }
        Map chunkTEs = chunk.field_150816_i;
        for (TileEntity te : chunkTEs.values()) {
            String teName = this.getTileEntityName(te);
            tileEntityCounts.merge(teName, 1, Integer::sum);
            ++stats.totalTileEntities;
        }
        stats.entityCounts = entityCounts;
        stats.tileEntityCounts = tileEntityCounts;
        stats.droppedItems = droppedItems;
        stats.hasNearbyPlayer = this.hasPlayerNearby(world, stats.blockX, stats.blockZ, 128);
        return stats;
    }

    private boolean hasPlayerNearby(WorldServer world, int x, int z, int distance) {
        for (Object obj : world.field_73010_i) {
            if (!(obj instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)obj;
            double dx = player.field_70165_t - (double)x;
            double dz = player.field_70161_v - (double)z;
            if (!(dx * dx + dz * dz < (double)(distance * distance))) continue;
            return true;
        }
        return false;
    }

    private String getEntityName(Entity entity) {
        String className = entity.getClass().getSimpleName();
        if (className.startsWith("Entity")) {
            return className.substring(6);
        }
        return className;
    }

    private String getTileEntityName(TileEntity te) {
        String className = te.getClass().getSimpleName();
        if (className.contains("MetaTileEntity") || className.contains("BaseMetaTileEntity")) {
            try {
                if (te.getClass().getName().contains("gregtech")) {
                    return "GT:" + className;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (className.startsWith("TileEntity")) {
            return className.substring(10);
        }
        if (className.startsWith("Tile")) {
            return className.substring(4);
        }
        return className;
    }

    private String getItemKey(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return "Unknown";
        }
        try {
            String unlocalizedName = stack.func_77973_b().func_77667_c(stack);
            int meta = stack.func_77960_j();
            return unlocalizedName + ":" + meta;
        }
        catch (Exception e) {
            return stack.func_77973_b().getClass().getSimpleName();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeStatsToLog(List<ChunkStats> topChunks, int totalEntities, int totalTileEntities, int totalLoadedChunks, int totalPlayers, Map<String, Integer> globalEntityCounts, Map<String, Integer> globalTileEntityCounts, Map<String, ItemInfo> droppedItemsDetails) {
        this.ensureLogFile();
        try (PrintWriter w = new PrintWriter(new FileWriter(this.logFile, true));){
            String timestamp = DATE_FORMAT.format(new Date());
            double tps = this.calculateTPS();
            w.println("################################################################################");
            w.println("# SERVER PERFORMANCE REPORT - " + timestamp);
            w.println("################################################################################");
            w.println();
            w.println("=== SERVER OVERVIEW ===");
            w.println(String.format("TPS: %.2f / 20.00 (%.1f%%)", tps, tps / 20.0 * 100.0));
            w.println(String.format("Players Online: %d", totalPlayers));
            w.println(String.format("Loaded Chunks: %d", totalLoadedChunks));
            w.println(String.format("Total Entities: %d", totalEntities));
            w.println(String.format("Total TileEntities: %d", totalTileEntities));
            w.println();
            w.println("=== TOP TILEENTITIES BY TYPE (potential lag sources) ===");
            ArrayList<Map.Entry<String, Integer>> sortedTEs = new ArrayList<Map.Entry<String, Integer>>(globalTileEntityCounts.entrySet());
            sortedTEs.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
            int teRank = 1;
            for (Map.Entry entry : sortedTEs) {
                if (teRank > 15) break;
                w.println(String.format("  %2d. %-45s : %5d", teRank++, entry.getKey(), entry.getValue()));
            }
            w.println();
            w.println("=== TOP ENTITIES BY TYPE ===");
            ArrayList<Map.Entry<String, Integer>> sortedEntities = new ArrayList<Map.Entry<String, Integer>>(globalEntityCounts.entrySet());
            sortedEntities.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
            boolean bl = true;
            for (Map.Entry entry : sortedEntities) {
                void var16_20;
                if (var16_20 > 15) break;
                w.println(String.format("  %2d. %-35s : %5d", (int)(++var16_20), entry.getKey(), entry.getValue()));
            }
            w.println();
            if (!droppedItemsDetails.isEmpty()) {
                w.println("=== DROPPED ITEMS DETAILS ===");
                ArrayList<Map.Entry<String, ItemInfo>> sortedItems = new ArrayList<Map.Entry<String, ItemInfo>>(droppedItemsDetails.entrySet());
                sortedItems.sort((a, b) -> Integer.compare(((ItemInfo)b.getValue()).entityCount, ((ItemInfo)a.getValue()).entityCount));
                boolean bl2 = true;
                for (Map.Entry entry : sortedItems) {
                    void var18_25;
                    if (var18_25 > 20) break;
                    ItemInfo info = (ItemInfo)entry.getValue();
                    w.println(String.format("  %2d. %s", (int)(++var18_25), info.displayName));
                    w.println(String.format("      ID: %s", entry.getKey()));
                    w.println(String.format("      Entities: %d, Total Items: %d", info.entityCount, info.count));
                    if (info.sampleX == 0.0 && info.sampleZ == 0.0) continue;
                    w.println(String.format("      Sample Location: [%.0f, %.0f, %.0f] Dim: %d", info.sampleX, info.sampleY, info.sampleZ, info.sampleDim));
                }
                w.println();
            }
            w.println("=== TOP " + topChunks.size() + " CHUNKS BY LOAD ===");
            w.println("(Sorted by: Entities + TileEntities*2)");
            w.println();
            int chunkRank = 1;
            for (ChunkStats stats : topChunks) {
                int shown;
                StringBuilder sb;
                ArrayList<Map.Entry<String, Integer>> sorted;
                int n = stats.totalEntities + stats.totalTileEntities * 2;
                String playerIndicator = stats.hasNearbyPlayer ? " [PLAYER NEARBY]" : "";
                w.println(String.format("#%d - Load Score: %d%s", chunkRank++, n, playerIndicator));
                w.println(String.format("    Location: [%d, %d, %d] (Dim: %d, Chunk: %d, %d)", stats.blockX, stats.blockY, stats.blockZ, stats.dimensionId, stats.chunkX, stats.chunkZ));
                w.println(String.format("    Entities: %d, TileEntities: %d", stats.totalEntities, stats.totalTileEntities));
                if (!stats.entityCounts.isEmpty()) {
                    sorted = new ArrayList<Map.Entry<String, Integer>>(stats.entityCounts.entrySet());
                    sorted.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
                    sb = new StringBuilder("    Entities: ");
                    shown = 0;
                    for (Map.Entry entry : sorted) {
                        if (shown > 0) {
                            sb.append(", ");
                        }
                        sb.append((String)entry.getKey()).append(":").append(entry.getValue());
                        if (++shown < 8) continue;
                        if (sorted.size() <= 8) break;
                        sb.append(", ...");
                        break;
                    }
                    w.println(sb.toString());
                }
                if (!stats.tileEntityCounts.isEmpty()) {
                    sorted = new ArrayList<Map.Entry<String, Integer>>(stats.tileEntityCounts.entrySet());
                    sorted.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
                    sb = new StringBuilder("    TileEntities: ");
                    shown = 0;
                    for (Map.Entry entry : sorted) {
                        if (shown > 0) {
                            sb.append(", ");
                        }
                        sb.append((String)entry.getKey()).append(":").append(entry.getValue());
                        if (++shown < 8) continue;
                        if (sorted.size() <= 8) break;
                        sb.append(", ...");
                        break;
                    }
                    w.println(sb.toString());
                }
                w.println();
            }
            w.println("################################################################################");
            w.println();
            w.flush();
            CointCore.LOG.info("Server stats logged: {} entities, {} TEs in {} chunks, TPS: {:.2f}", new Object[]{totalEntities, totalTileEntities, totalLoadedChunks, tps});
        }
        catch (IOException e) {
            CointCore.LOG.error("Failed to write server stats to log: {}", new Object[]{e.getMessage()});
        }
    }

    private void ensureLogFile() {
        if (this.logFile == null) {
            File logsDir = new File("logs");
            if (!logsDir.exists()) {
                logsDir.mkdirs();
            }
            this.logFile = new File(logsDir, "serverstats.log");
        }
    }

    private static class ChunkStats {
        int chunkX;
        int chunkZ;
        int dimensionId;
        int blockX;
        int blockY;
        int blockZ;
        int totalEntities;
        int totalTileEntities;
        boolean hasNearbyPlayer;
        Map<String, Integer> entityCounts = new HashMap<String, Integer>();
        Map<String, Integer> tileEntityCounts = new HashMap<String, Integer>();
        Map<String, ItemInfo> droppedItems = new HashMap<String, ItemInfo>();

        private ChunkStats() {
        }
    }

    private static class ItemInfo {
        String displayName;
        int count;
        int entityCount;
        double sampleX;
        double sampleY;
        double sampleZ;
        int sampleDim;

        ItemInfo(ItemStack stack) {
            try {
                this.displayName = stack.func_82833_r();
            }
            catch (Exception e) {
                this.displayName = stack.func_77973_b().getClass().getSimpleName();
            }
            this.count = 0;
            this.entityCount = 0;
        }

        ItemInfo(String name, int meta) {
            this.displayName = name;
            this.count = 0;
            this.entityCount = 0;
        }

        void addLocation(double x, double y, double z, int dim) {
            if (this.sampleX == 0.0 && this.sampleZ == 0.0) {
                this.sampleX = x;
                this.sampleY = y;
                this.sampleZ = z;
                this.sampleDim = dim;
            }
        }

        static ItemInfo merge(ItemInfo a, ItemInfo b) {
            ItemInfo result = new ItemInfo(a.displayName, 0);
            result.count = a.count + b.count;
            result.entityCount = a.entityCount + b.entityCount;
            result.sampleX = a.sampleX != 0.0 ? a.sampleX : b.sampleX;
            result.sampleY = a.sampleY != 0.0 ? a.sampleY : b.sampleY;
            result.sampleZ = a.sampleZ != 0.0 ? a.sampleZ : b.sampleZ;
            result.sampleDim = a.sampleDim;
            return result;
        }
    }
}

