/*
 * Decompiled with CFR 0.152.
 */
package coint.module.epochsync;

import betterquesting.api.utils.UuidConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class EpochRegistry {
    public static final String RANK_START = "bravebro";
    public static final String RANK_STONE = "stone";
    public static final String RANK_STEAM = "steam";
    public static final String RANK_LV = "lv";
    public static final String RANK_MV = "mv";
    public static final String RANK_HV = "hv";
    public static final String RANK_EV = "ev";
    public static final String RANK_IV = "iv";
    public static final String RANK_LUV = "luv";
    public static final String RANK_ZPM = "zpm";
    public static final String RANK_UV = "uv";
    public static final String RANK_UHV = "uhv";
    public static final String RANK_UEV = "uev";
    public static final String RANK_UIV = "uiv";
    public static final String RANK_UMV = "umv";
    public static final String RANK_UXV = "uxv";
    public static final String RANK_STARGATEOWNER = "stargateowner";
    private static final List<String> EPOCH_ORDER = Collections.unmodifiableList(Arrays.asList("bravebro", "stone", "steam", "lv", "mv", "hv", "ev", "iv", "luv", "zpm", "uv", "uhv", "uev", "uiv", "umv", "uxv", "stargateowner"));
    private static final Set<String> EPOCH_RANKS = Collections.unmodifiableSet(new HashSet<String>(EPOCH_ORDER));
    private static final Map<String, Integer> EPOCH_PRIORITY = new HashMap<String, Integer>();
    private static final Map<UUID, String> QUEST_EPOCH_MAP;

    private EpochRegistry() {
    }

    public static boolean isEpoch(String rank) {
        return rank != null && EPOCH_RANKS.contains(rank.toLowerCase());
    }

    public static Set<String> getAllEpochs() {
        return EPOCH_RANKS;
    }

    public static String getEpochForQuest(UUID questId) {
        return QUEST_EPOCH_MAP.get(questId);
    }

    public static boolean hasExplicitMapping(UUID questId) {
        return QUEST_EPOCH_MAP.containsKey(questId);
    }

    public static boolean isEpochQuest(UUID questId) {
        return QUEST_EPOCH_MAP.containsKey(questId);
    }

    public static Map<UUID, String> getQuestEpochMap() {
        return Collections.unmodifiableMap(QUEST_EPOCH_MAP);
    }

    public static int getEpochPriority(String epoch) {
        if (epoch == null) {
            return -1;
        }
        Integer priority = EPOCH_PRIORITY.get(epoch.toLowerCase());
        return priority != null ? priority : -1;
    }

    public static int compareEpochs(String epoch1, String epoch2) {
        return EpochRegistry.getEpochPriority(epoch1) - EpochRegistry.getEpochPriority(epoch2);
    }

    public static boolean isHigherEpoch(String epoch1, String epoch2) {
        return EpochRegistry.compareEpochs(epoch1, epoch2) > 0;
    }

    public static List<String> getEpochOrder() {
        return EPOCH_ORDER;
    }

    public static String getNextEpoch(String currentEpoch) {
        int priority = EpochRegistry.getEpochPriority(currentEpoch);
        if (priority < 0 || priority >= EPOCH_ORDER.size() - 1) {
            return null;
        }
        return EPOCH_ORDER.get(priority + 1);
    }

    public static String getPreviousEpoch(String currentEpoch) {
        int priority = EpochRegistry.getEpochPriority(currentEpoch);
        if (priority <= 0) {
            return null;
        }
        return EPOCH_ORDER.get(priority - 1);
    }

    static {
        for (int i = 0; i < EPOCH_ORDER.size(); ++i) {
            EPOCH_PRIORITY.put(EPOCH_ORDER.get(i), i);
        }
        QUEST_EPOCH_MAP = new HashMap<UUID, String>();
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAAAA=="), RANK_START);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAADw=="), RANK_STONE);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAALA=="), RANK_STEAM);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAAWA=="), RANK_LV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAEfA=="), RANK_MV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAAoA=="), RANK_HV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAAsA=="), RANK_EV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAA1Q=="), RANK_IV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAF1Q=="), RANK_LUV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAKMg=="), RANK_ZPM);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAKNQ=="), RANK_UV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAKOA=="), RANK_UHV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"k9PA3buhTvK1EJpPfA8ZAg=="), RANK_UEV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"u-1Y-eQ-TLyw-WGi5EEnVA=="), RANK_UIV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"jlXvqqgIQ_Crha2tW0gEQg=="), RANK_UMV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"7wI7VuLKRe6lqAJpuYKKJg=="), RANK_UXV);
        QUEST_EPOCH_MAP.put(UuidConverter.decodeUuid((String)"AAAAAAAAAAAAAAAAAAAKJg=="), RANK_STARGATEOWNER);
    }
}

