/*
 * Decompiled with CFR 0.152.
 */
package coint.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandParser {
    private static final Logger LOG = LogManager.getLogger(CommandParser.class);
    private static final Pattern RANKS_ADD_PATTERN = Pattern.compile("/ranks\\s+add\\s+(?:@p|VAR_NAME|VAR_UUID|\\S+)\\s+(\\w+)", 2);
    private static final Pattern RANKS_GENERAL_PATTERN = Pattern.compile("/ranks?\\s+(?:add|set|assign)\\s+\\S+\\s+(\\w+)", 2);

    private CommandParser() {
    }

    @Nullable
    public static String parseRankFromCommand(String command) {
        if (command == null || command.isEmpty()) {
            return null;
        }
        Matcher matcher = RANKS_ADD_PATTERN.matcher(command);
        if (matcher.find()) {
            String rank = matcher.group(1);
            LOG.debug("Parsed rank '{}' from command: {}", new Object[]{rank, command});
            return rank;
        }
        matcher = RANKS_GENERAL_PATTERN.matcher(command);
        if (matcher.find()) {
            String rank = matcher.group(1);
            LOG.debug("Parsed rank '{}' from command (general pattern): {}", new Object[]{rank, command});
            return rank;
        }
        LOG.debug("Could not parse rank from command: {}", new Object[]{command});
        return null;
    }

    public static boolean isRanksAddCommand(String command) {
        if (command == null || command.isEmpty()) {
            return false;
        }
        return RANKS_ADD_PATTERN.matcher(command).find() || RANKS_GENERAL_PATTERN.matcher(command).find();
    }

    public static String substitutePlayer(String command, String playerName) {
        return command.replaceAll("@p", playerName).replaceAll("VAR_NAME", playerName);
    }

    public static String substituteUUID(String command, String playerUUID) {
        return command.replaceAll("VAR_UUID", playerUUID);
    }
}

