/*
 * Decompiled with CFR 0.152.
 */
package coint.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HttpUtil {
    private static final Logger LOG = LogManager.getLogger(HttpUtil.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 10000;

    private HttpUtil() {
    }

    public static CompletableFuture<Integer> postJsonAsync(String urlString, String jsonData) {
        return CompletableFuture.supplyAsync(() -> HttpUtil.postJson(urlString, jsonData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int postJson(String urlString, String jsonData) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setDoOutput(true);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonData.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            LOG.debug("HTTP POST {} - Response: {}", new Object[]{urlString, responseCode});
            int n = responseCode;
            return n;
        }
        catch (IOException e) {
            LOG.error("HTTP POST error for {}: {}", new Object[]{urlString, e.getMessage()});
            int n = -1;
            return n;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String urlString) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String string = response.toString();
                    return string;
                }
            }
            LOG.warn("HTTP GET {} returned status {}", new Object[]{urlString, responseCode});
        }
        catch (IOException e) {
            LOG.error("HTTP GET error for {}: {}", new Object[]{urlString, e.getMessage()});
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        String string = null;
        return string;
    }

    public static CompletableFuture<String> getAsync(String urlString) {
        return CompletableFuture.supplyAsync(() -> HttpUtil.get(urlString));
    }
}

