/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.utils;

import com.caedis.duradisplay.config.ConfigDurabilityLike;
import java.awt.Color;

public enum ColorType {
    RYGDurability{

        private int get(double percent) {
            return Color.HSBtoRGB(Math.max(0.0f, (float)percent) / 3.0f, 1.0f, 1.0f);
        }

        @Override
        public int get(double percent, ConfigDurabilityLike config) {
            return this.get(percent);
        }
    }
    ,
    Threshold{

        @Override
        public int get(double percent, ConfigDurabilityLike config) {
            double dur = percent * 100.0;
            if (dur <= config.colorThreshold[0]) {
                return config.threeColors[0];
            }
            if (dur >= config.colorThreshold[config.colorThreshold.length - 1]) {
                return config.threeColors[1];
            }
            return config.threeColors[2];
        }
    }
    ,
    Vanilla{

        private int get(double percent) {
            int k = (int)Math.round(percent * 255.0);
            return 255 - k << 16 | k << 8;
        }

        @Override
        public int get(double percent, ConfigDurabilityLike config) {
            return this.get(percent);
        }
    }
    ,
    Single{

        @Override
        public int get(double percent, ConfigDurabilityLike config) {
            return config.color;
        }
    }
    ,
    Smooth{

        @Override
        public int get(double percent, ConfigDurabilityLike config) {
            int c0 = config.threeColors[0];
            int c1 = config.threeColors[1];
            int c2 = config.threeColors[2];
            int r = (int)((double)(c0 >> 16 & 0xFF) * (1.0 - percent) + (double)(c1 >> 16 & 0xFF) * percent);
            int g = (int)((double)(c0 >> 8 & 0xFF) * (1.0 - percent) + (double)(c1 >> 8 & 0xFF) * percent);
            int b = (int)((double)(c0 & 0xFF) * (1.0 - percent) + (double)(c1 & 0xFF) * percent);
            int r2 = (int)((double)(c1 >> 16 & 0xFF) * (1.0 - percent) + (double)(c2 >> 16 & 0xFF) * percent);
            int g2 = (int)((double)(c1 >> 8 & 0xFF) * (1.0 - percent) + (double)(c2 >> 8 & 0xFF) * percent);
            int b2 = (int)((double)(c1 & 0xFF) * (1.0 - percent) + (double)(c2 & 0xFF) * percent);
            int r3 = (int)((double)r * (1.0 - percent) + (double)r2 * percent);
            int g3 = (int)((double)g * (1.0 - percent) + (double)g2 * percent);
            int b3 = (int)((double)b * (1.0 - percent) + (double)b2 * percent);
            return r3 << 16 | g3 << 8 | b3;
        }
    };


    public abstract int get(double var1, ConfigDurabilityLike var3);
}

